/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.vault;

import fr.skynex.myEconomy.EconomyManager;
import fr.skynex.myEconomy.MyEconomy;
import java.util.Collections;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class MyEconomyVault
implements Economy {
    private final MyEconomy plugin;
    private final EconomyManager economyManager;

    public MyEconomyVault(MyEconomy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
    }

    public boolean isEnabled() {
        return this.plugin != null && this.plugin.isEnabled();
    }

    public String getName() {
        return "MyEconomy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        String currency = amount <= 1.0 ? this.plugin.getConfigManager().getCurrencySingular() : this.plugin.getConfigManager().getCurrencyPlural();
        return String.format("%.2f %s", amount, currency);
    }

    public String currencyNamePlural() {
        return this.plugin.getConfigManager().getCurrencyPlural();
    }

    public String currencyNameSingular() {
        return this.plugin.getConfigManager().getCurrencySingular();
    }

    public boolean hasAccount(String playerName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player) {
        return true;
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public double getBalance(String playerName) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        return this.getBalance(player);
    }

    public double getBalance(OfflinePlayer player) {
        return this.economyManager.getBalance(player.getUniqueId());
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(String playerName, double amount) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        return this.has(player, amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.economyManager.hasBalance(player.getUniqueId(), amount);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Amount cannot be negative");
        }
        if (this.economyManager.removeBalance(player.getUniqueId(), amount)) {
            return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Insufficient balance");
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(playerName);
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Amount cannot be negative");
        }
        this.economyManager.addBalance(player.getUniqueId(), amount);
        return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    public boolean createPlayerAccount(String playerName) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return true;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return true;
    }
}

