/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.util;

import fr.skynex.myEconomy.MyEconomy;

public class CurrencyFormatter {
    private final MyEconomy plugin;

    public CurrencyFormatter(MyEconomy plugin) {
        this.plugin = plugin;
    }

    public String formatShort(double amount) {
        if (!this.plugin.getConfigManager().isShortFormatEnabled()) {
            return this.formatFull(amount);
        }
        if (amount >= 1.0E12) {
            return String.format("%.1fT", amount / 1.0E12);
        }
        if (amount >= 1.0E9) {
            return String.format("%.1fB", amount / 1.0E9);
        }
        if (amount >= 1000000.0) {
            return String.format("%.1fM", amount / 1000000.0);
        }
        if (amount >= 1000.0) {
            return String.format("%.1fK", amount / 1000.0);
        }
        int decimals = this.plugin.getConfigManager().getCurrencyDecimals();
        return decimals == 0 ? String.format("%.0f", amount) : String.format("%." + decimals + "f", amount);
    }

    public String formatFull(double amount) {
        String formatted;
        int decimals = this.plugin.getConfigManager().getCurrencyDecimals();
        String string = formatted = decimals == 0 ? String.format("%.0f", amount) : String.format("%." + decimals + "f", amount);
        if (this.plugin.getConfigManager().isThousandSeparatorEnabled()) {
            formatted = this.addThousandSeparator(formatted);
        }
        return formatted;
    }

    private String addThousandSeparator(String number) {
        int dotIndex = number.indexOf(46);
        String intPart = dotIndex >= 0 ? number.substring(0, dotIndex) : number;
        String decPart = dotIndex >= 0 ? number.substring(dotIndex) : "";
        StringBuilder sb = new StringBuilder();
        int len = intPart.length();
        for (int i = 0; i < len; ++i) {
            if (i > 0 && (len - i) % 3 == 0) {
                sb.append(this.plugin.getConfigManager().getThousandSeparator());
            }
            sb.append(intPart.charAt(i));
        }
        return sb.toString() + decPart;
    }

    public String formatWithCurrency(double amount, boolean shortFormat) {
        String formatted = shortFormat ? this.formatShort(amount) : this.formatFull(amount);
        String currency = amount <= 1.0 ? this.plugin.getConfigManager().getCurrencySingular() : this.plugin.getConfigManager().getCurrencyPlural();
        return formatted + " " + currency;
    }

    public String formatWithCurrency(double amount) {
        return this.formatWithCurrency(amount, this.plugin.getConfigManager().isShortFormatEnabled());
    }
}

