/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.placeholder;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.RankingManager;
import fr.skynex.myEconomy.util.CurrencyFormatter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyEconomyPlaceholders
extends PlaceholderExpansion {
    private final MyEconomy plugin;

    public MyEconomyPlaceholders(MyEconomy plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "myeconomy";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getPluginMeta().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player == null || !player.hasPlayedBefore()) {
            return "";
        }
        UUID uuid = player.getUniqueId();
        CurrencyFormatter formatter = new CurrencyFormatter(this.plugin);
        double balance = this.plugin.getEconomyManager().getBalance(uuid);
        return switch (params.toLowerCase()) {
            case "balance" -> String.format("%.2f", balance);
            case "balance_formatted" -> formatter.formatWithCurrency(balance);
            case "balance_short" -> formatter.formatShort(balance);
            case "currency" -> {
                if (balance <= 1.0) {
                    yield this.plugin.getConfigManager().getCurrencySingular();
                }
                yield this.plugin.getConfigManager().getCurrencyPlural();
            }
            case "rank" -> String.valueOf(this.getRank(uuid, null));
            case "rank_weekly" -> String.valueOf(this.getRank(uuid, "weekly"));
            case "rank_monthly" -> String.valueOf(this.getRank(uuid, "monthly"));
            default -> null;
        };
    }

    private int getRank(UUID uuid, String period) {
        RankingManager rm = this.plugin.getRankingManager();
        List<Map.Entry<UUID, Double>> list = period == null ? rm.getTopBalances(this.plugin.getConfigManager().getTopSize()) : (period.equals("weekly") ? rm.getWeeklyTop(this.plugin.getConfigManager().getTopSize()) : rm.getMonthlyTop(this.plugin.getConfigManager().getTopSize()));
        int rank = 1;
        for (Map.Entry<UUID, Double> entry : list) {
            if (entry.getKey().equals(uuid)) {
                return rank;
            }
            ++rank;
        }
        return 0;
    }
}

