/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.hologram;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import fr.skynex.myEconomy.MyEconomy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class HologramManager {
    private final MyEconomy plugin;
    private boolean decentHologramsEnabled;
    private final Map<String, Location> hologramLocations;
    private BukkitTask updateTask;
    public static final String TYPE_GLOBAL = "global";
    public static final String TYPE_WEEKLY = "weekly";
    public static final String TYPE_MONTHLY = "monthly";
    public static final List<String> VALID_TYPES = Arrays.asList("global", "weekly", "monthly");

    public HologramManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.hologramLocations = new HashMap<String, Location>();
        this.checkDecentHolograms();
        if (this.decentHologramsEnabled && this.isHologramsEnabled()) {
            this.loadHologramLocations();
            this.startUpdateTask();
            plugin.getLogger().info("Hologram system enabled with DecentHolograms!");
        } else if (!this.decentHologramsEnabled) {
            plugin.getLogger().info("DecentHolograms not found - Holograms disabled.");
        }
    }

    private void checkDecentHolograms() {
        this.decentHologramsEnabled = Bukkit.getPluginManager().getPlugin("DecentHolograms") != null;
    }

    public boolean isHologramsEnabled() {
        return this.plugin.getConfig().getBoolean("holograms.enabled", true);
    }

    public int getUpdateInterval() {
        return this.plugin.getConfig().getInt("holograms.update-interval", 60);
    }

    private void loadHologramLocations() {
        FileConfiguration config = this.plugin.getConfig();
        for (String type : VALID_TYPES) {
            String path = "holograms.locations." + type;
            if (!config.contains(path + ".world")) continue;
            String worldName = config.getString(path + ".world");
            double x = config.getDouble(path + ".x");
            double y = config.getDouble(path + ".y");
            double z = config.getDouble(path + ".z");
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) continue;
            Location loc = new Location(world, x, y, z);
            this.hologramLocations.put(type, loc);
            this.createHologramInternal(type, loc);
        }
    }

    private void saveHologramLocations() {
        FileConfiguration config = this.plugin.getConfig();
        for (Map.Entry<String, Location> entry : this.hologramLocations.entrySet()) {
            String type = entry.getKey();
            Location loc = entry.getValue();
            String path = "holograms.locations." + type;
            config.set(path + ".world", (Object)loc.getWorld().getName());
            config.set(path + ".x", (Object)loc.getX());
            config.set(path + ".y", (Object)loc.getY());
            config.set(path + ".z", (Object)loc.getZ());
        }
        this.plugin.saveConfig();
    }

    private void startUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        int intervalSeconds = this.getUpdateInterval();
        long intervalTicks = 20L * (long)intervalSeconds;
        this.updateTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, this::updateAllHolograms), 20L, intervalTicks);
    }

    public boolean createHologram(String type, Location location) {
        if (!this.decentHologramsEnabled) {
            return false;
        }
        if (!VALID_TYPES.contains(type.toLowerCase())) {
            return false;
        }
        type = type.toLowerCase();
        this.deleteHologram(type);
        this.hologramLocations.put(type, location);
        this.saveHologramLocations();
        return this.createHologramInternal(type, location);
    }

    private boolean createHologramInternal(String type, Location location) {
        if (!this.decentHologramsEnabled) {
            return false;
        }
        try {
            List<String> lines = this.buildHologramLines(type);
            String hologramName = "myeconomy_top_" + type;
            if (DHAPI.getHologram((String)hologramName) != null) {
                DHAPI.removeHologram((String)hologramName);
            }
            DHAPI.createHologram((String)hologramName, (Location)location, (boolean)false, lines);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to create hologram: " + e.getMessage());
            return false;
        }
    }

    public boolean deleteHologram(String type) {
        if (!this.decentHologramsEnabled) {
            return false;
        }
        type = type.toLowerCase();
        try {
            String hologramName = "myeconomy_top_" + type;
            if (DHAPI.getHologram((String)hologramName) != null) {
                DHAPI.removeHologram((String)hologramName);
            }
            this.hologramLocations.remove(type);
            this.saveHologramLocations();
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to delete hologram: " + e.getMessage());
            return false;
        }
    }

    public void updateAllHolograms() {
        if (!this.decentHologramsEnabled) {
            return;
        }
        for (String type : this.hologramLocations.keySet()) {
            this.updateHologram(type);
        }
    }

    public void updateHologram(String type) {
        if (!this.decentHologramsEnabled) {
            return;
        }
        try {
            String hologramName = "myeconomy_top_" + type;
            Hologram hologram = DHAPI.getHologram((String)hologramName);
            if (hologram != null) {
                List<String> lines = this.buildHologramLines(type);
                DHAPI.setHologramLines((Hologram)hologram, lines);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to update hologram: " + e.getMessage());
        }
    }

    private List<String> buildHologramLines(String type) {
        ArrayList<String> lines = new ArrayList<String>();
        FileConfiguration config = this.plugin.getConfig();
        lines.add(this.translateColors(switch (type) {
            case TYPE_WEEKLY -> config.getString("holograms.format.title-weekly", "&a&l--- TOP WEEKLY ---");
            case TYPE_MONTHLY -> config.getString("holograms.format.title-monthly", "&b&l--- TOP MONTHLY ---");
            default -> config.getString("holograms.format.title-global", "&6&l--- TOP GLOBAL ---");
        }));
        lines.add("");
        List<Map.Entry<UUID, Double>> topPlayers = this.getTopPlayersForType(type);
        if (topPlayers.isEmpty()) {
            String noData = config.getString("holograms.format.no-data", "&7No players yet");
            lines.add(this.translateColors(noData));
        } else {
            String lineFormat = config.getString("holograms.format.line-format", "&e#{rank} &f{player} &7- &a{balance}");
            String currency = this.plugin.getConfigManager().getCurrencySymbol();
            if (currency.isEmpty()) {
                currency = this.plugin.getConfigManager().getCurrencyPlural();
            }
            int rank = 1;
            for (Map.Entry<UUID, Double> entry : topPlayers) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)entry.getKey());
                String playerName = player.getName() != null ? player.getName() : "Unknown";
                String balance = this.formatBalance(entry.getValue());
                String line = lineFormat.replace("{rank}", String.valueOf(rank)).replace("{player}", playerName).replace("{balance}", balance).replace("{currency}", currency);
                lines.add(this.translateColors(line));
                ++rank;
            }
        }
        return lines;
    }

    private List<Map.Entry<UUID, Double>> getTopPlayersForType(String type) {
        int limit = 10;
        switch (type) {
            case "weekly": {
                return this.plugin.getRankingManager().getWeeklyTop(limit);
            }
            case "monthly": {
                return this.plugin.getRankingManager().getMonthlyTop(limit);
            }
        }
        return this.plugin.getRankingManager().getTopBalances(limit);
    }

    private String formatBalance(double balance) {
        String symbol = this.plugin.getConfigManager().getCurrencySymbol();
        int decimals = this.plugin.getConfigManager().getCurrencyDecimals();
        String formatted = String.format("%,." + decimals + "f", balance);
        if (!symbol.isEmpty()) {
            return symbol + formatted;
        }
        return formatted;
    }

    private String translateColors(String text) {
        if (text == null) {
            return "";
        }
        return text.replace('&', '\u00a7');
    }

    public boolean isDecentHologramsEnabled() {
        return this.decentHologramsEnabled;
    }

    public Map<String, Location> getHologramLocations() {
        return new HashMap<String, Location>(this.hologramLocations);
    }

    public boolean hologramExists(String type) {
        return this.hologramLocations.containsKey(type.toLowerCase());
    }

    public void shutdown() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        this.saveHologramLocations();
    }

    public void reload() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.hologramLocations.clear();
        if (this.decentHologramsEnabled && this.isHologramsEnabled()) {
            this.loadHologramLocations();
            this.startUpdateTask();
            this.updateAllHolograms();
        }
    }
}

