/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.gui;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.integration.DynamicPricingSystem;
import fr.skynex.myEconomy.market.MarketIntelligence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MarketPricesGUI
implements Listener {
    private final MyEconomy plugin;
    private static final Map<String, List<Material>> CATEGORIES = new LinkedHashMap<String, List<Material>>();
    private final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();
    private final Map<UUID, String> playerCategories = new HashMap<UUID, String>();

    public MarketPricesGUI(MyEconomy plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openCategoriesMenu(Player player) {
        TextComponent title = LegacyComponentSerializer.legacySection().deserialize("\u00a76\u00a7lMarket - Categories");
        Inventory inv = Bukkit.createInventory(null, (int)36, (Component)title);
        this.fillBorder(inv, Material.GRAY_STAINED_GLASS_PANE);
        int slot = 10;
        Material[] categoryIcons = new Material[]{Material.DIAMOND, Material.OAK_LOG, Material.STONE, Material.BREAD, Material.DIAMOND_SWORD, Material.REDSTONE, Material.LANTERN, Material.ENCHANTING_TABLE, Material.NETHER_STAR};
        int i = 0;
        for (String category : CATEGORIES.keySet()) {
            if (slot == 17) {
                slot = 19;
            }
            Material icon = i < categoryIcons.length ? categoryIcons[i] : Material.CHEST;
            int itemCount = CATEGORIES.get(category).size();
            ItemStack item = this.createItem(icon, "\u00a7e\u00a7l" + category, "\u00a77View prices in this category", "\u00a77Items: \u00a7a" + itemCount, "", "\u00a7aClick to view");
            inv.setItem(slot, item);
            ++slot;
            ++i;
        }
        inv.setItem(31, this.createItem(Material.BARRIER, "\u00a7c\u00a7lClose", "\u00a77Close menu"));
        player.openInventory(inv);
        this.playerCategories.remove(player.getUniqueId());
    }

    public void openPricesMenu(Player player, String category, int page) {
        List<Material> materials = CATEGORIES.get(category);
        if (materials == null) {
            this.openCategoriesMenu(player);
            return;
        }
        int itemsPerPage = 45;
        int totalPages = (int)Math.ceil((double)materials.size() / (double)itemsPerPage);
        page = Math.max(0, Math.min(page, totalPages - 1));
        TextComponent title = LegacyComponentSerializer.legacySection().deserialize("\u00a76\u00a7lMarket - " + category + " \u00a77(" + (page + 1) + "/" + totalPages + ")");
        Inventory inv = Bukkit.createInventory(null, (int)54, (Component)title);
        int startIndex = page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, materials.size());
        MarketIntelligence market = this.plugin.getMarketIntelligence();
        DynamicPricingSystem pricing = null;
        if (this.plugin.getAuctionHouseIntegration() != null) {
            pricing = this.plugin.getAuctionHouseIntegration().getDynamicPricing();
        }
        for (int i = startIndex; i < endIndex; ++i) {
            double basePrice;
            MarketIntelligence.MarketStats stats;
            Material mat = materials.get(i);
            int slot = i - startIndex;
            double pricePerItem = 0.0;
            Object priceSource = "\u00a77No data";
            int transactions = 0;
            if (market != null && (stats = market.getMarketStats(mat)) != null && stats.weightedAveragePrice > 0.0) {
                pricePerItem = stats.weightedAveragePrice;
                priceSource = "\u00a7aLearned (" + stats.transactionCount + " sales)";
                transactions = stats.transactionCount;
            }
            if (pricePerItem <= 0.0 && pricing != null && (basePrice = pricing.getBasePrice(mat)) > 0.0) {
                pricePerItem = basePrice / 64.0;
                priceSource = "\u00a7eBase price";
            }
            ItemStack item = new ItemStack(mat);
            ItemMeta meta = item.getItemMeta();
            String displayName = this.formatMaterialName(mat);
            meta.displayName((Component)LegacyComponentSerializer.legacySection().deserialize("\u00a7f" + displayName));
            ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
            lore.add(LegacyComponentSerializer.legacySection().deserialize("\u00a77" + "=".repeat(25)));
            if (pricePerItem > 0.0) {
                lore.add(LegacyComponentSerializer.legacySection().deserialize("\u00a7ePrice per item: \u00a7a" + String.format("%.2f", pricePerItem) + " coins"));
                lore.add(LegacyComponentSerializer.legacySection().deserialize("\u00a7ePrice per stack (64): \u00a7a" + String.format("%.2f", pricePerItem * 64.0) + " coins"));
            } else {
                lore.add(LegacyComponentSerializer.legacySection().deserialize("\u00a7cUnknown price"));
                lore.add(LegacyComponentSerializer.legacySection().deserialize("\u00a77No sales recorded"));
            }
            lore.add(LegacyComponentSerializer.legacySection().deserialize(""));
            lore.add(LegacyComponentSerializer.legacySection().deserialize("\u00a77Source: " + (String)priceSource));
            if (transactions > 0) {
                lore.add(LegacyComponentSerializer.legacySection().deserialize("\u00a77Transactions: \u00a7e" + transactions));
            }
            meta.lore(lore);
            item.setItemMeta(meta);
            inv.setItem(slot, item);
        }
        this.fillRow(inv, 45, Material.BLACK_STAINED_GLASS_PANE);
        if (page > 0) {
            inv.setItem(45, this.createItem(Material.ARROW, "\u00a7a<< Previous page", "\u00a77Go to page " + page));
        }
        inv.setItem(49, this.createItem(Material.CHEST, "\u00a77\u00a7lBack", "\u00a77Main menu"));
        if (page < totalPages - 1) {
            inv.setItem(53, this.createItem(Material.ARROW, "\u00a7aNext page >>", "\u00a77Go to page " + (page + 2)));
        }
        player.openInventory(inv);
        this.playerPages.put(player.getUniqueId(), page);
        this.playerCategories.put(player.getUniqueId(), category);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Component titleComponent = event.getView().title();
        String title = LegacyComponentSerializer.legacySection().serialize(titleComponent);
        if (!title.startsWith("\u00a76\u00a7lMarket")) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        int slot = event.getSlot();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (title.equals("\u00a76\u00a7lMarket - Categories")) {
            if (clicked.getType() == Material.BARRIER) {
                player.closeInventory();
                return;
            }
            int categoryIndex = 0;
            if (slot >= 10 && slot <= 16) {
                categoryIndex = slot - 10;
            } else if (slot >= 19 && slot <= 25) {
                categoryIndex = slot - 19 + 7;
            } else {
                return;
            }
            int i = 0;
            for (String category : CATEGORIES.keySet()) {
                if (i == categoryIndex) {
                    this.openPricesMenu(player, category, 0);
                    return;
                }
                ++i;
            }
        } else if (title.contains("Market -")) {
            String category = this.playerCategories.get(player.getUniqueId());
            int currentPage = this.playerPages.getOrDefault(player.getUniqueId(), 0);
            if (slot == 49 && clicked.getType() == Material.CHEST) {
                this.plugin.getMainEconomyGUI().openMainMenu(player);
                return;
            }
            if (slot == 45 && clicked.getType() == Material.ARROW) {
                this.openPricesMenu(player, category, currentPage - 1);
            } else if (slot == 53 && clicked.getType() == Material.ARROW) {
                this.openPricesMenu(player, category, currentPage + 1);
            }
        }
    }

    private ItemStack createItem(Material material, String name, String ... loreLines) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)LegacyComponentSerializer.legacySection().deserialize(name));
        if (loreLines.length > 0) {
            ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
            for (String line : loreLines) {
                lore.add(LegacyComponentSerializer.legacySection().deserialize(line));
            }
            meta.lore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private void fillBorder(Inventory inv, Material material) {
        int i;
        ItemStack pane = this.createItem(material, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            inv.setItem(i, pane);
            inv.setItem(inv.getSize() - 9 + i, pane);
        }
        for (i = 0; i < inv.getSize(); i += 9) {
            inv.setItem(i, pane);
            inv.setItem(i + 8, pane);
        }
    }

    private void fillRow(Inventory inv, int startSlot, Material material) {
        ItemStack pane = this.createItem(material, " ", new String[0]);
        for (int i = startSlot; i < startSlot + 9 && i < inv.getSize(); ++i) {
            inv.setItem(i, pane);
        }
    }

    private String formatMaterialName(Material material) {
        String name = material.name().replace("_", " ").toLowerCase();
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : name.toCharArray()) {
            if (c == ' ') {
                result.append(' ');
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    static {
        CATEGORIES.put("Ores", Arrays.asList(Material.COAL, Material.IRON_INGOT, Material.GOLD_INGOT, Material.DIAMOND, Material.EMERALD, Material.LAPIS_LAZULI, Material.REDSTONE, Material.QUARTZ, Material.NETHERITE_INGOT, Material.COPPER_INGOT, Material.AMETHYST_SHARD, Material.RAW_IRON, Material.RAW_GOLD, Material.RAW_COPPER, Material.COAL_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.LAPIS_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE));
        CATEGORIES.put("Wood", Arrays.asList(Material.OAK_LOG, Material.BIRCH_LOG, Material.SPRUCE_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG, Material.CHERRY_LOG, Material.OAK_PLANKS, Material.BIRCH_PLANKS, Material.SPRUCE_PLANKS, Material.JUNGLE_PLANKS, Material.ACACIA_PLANKS, Material.DARK_OAK_PLANKS, Material.MANGROVE_PLANKS, Material.CHERRY_PLANKS, Material.CRIMSON_STEM, Material.WARPED_STEM, Material.BAMBOO_BLOCK));
        CATEGORIES.put("Stones", Arrays.asList(Material.COBBLESTONE, Material.STONE, Material.GRANITE, Material.DIORITE, Material.ANDESITE, Material.DEEPSLATE, Material.COBBLED_DEEPSLATE, Material.TUFF, Material.CALCITE, Material.DRIPSTONE_BLOCK, Material.OBSIDIAN, Material.CRYING_OBSIDIAN, Material.NETHERRACK, Material.BASALT, Material.BLACKSTONE, Material.END_STONE, Material.SANDSTONE, Material.RED_SANDSTONE, Material.PRISMARINE, Material.PURPUR_BLOCK));
        CATEGORIES.put("Food", Arrays.asList(Material.WHEAT, Material.CARROT, Material.POTATO, Material.BEETROOT, Material.MELON_SLICE, Material.APPLE, Material.GOLDEN_APPLE, Material.ENCHANTED_GOLDEN_APPLE, Material.BREAD, Material.COOKED_BEEF, Material.COOKED_PORKCHOP, Material.COOKED_CHICKEN, Material.COOKED_MUTTON, Material.COOKED_SALMON, Material.COOKED_COD, Material.CAKE, Material.PUMPKIN_PIE, Material.COOKIE, Material.HONEY_BOTTLE, Material.GOLDEN_CARROT, Material.GLOW_BERRIES, Material.SWEET_BERRIES));
        CATEGORIES.put("Equipment", Arrays.asList(Material.DIAMOND_SWORD, Material.DIAMOND_PICKAXE, Material.DIAMOND_AXE, Material.DIAMOND_SHOVEL, Material.DIAMOND_HOE, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.NETHERITE_SWORD, Material.NETHERITE_PICKAXE, Material.NETHERITE_AXE, Material.NETHERITE_SHOVEL, Material.NETHERITE_HOE, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS, Material.BOW, Material.CROSSBOW, Material.TRIDENT, Material.SHIELD, Material.ELYTRA, Material.FISHING_ROD, Material.SHEARS));
        CATEGORIES.put("Redstone", Arrays.asList(Material.REDSTONE, Material.REDSTONE_BLOCK, Material.REDSTONE_TORCH, Material.REPEATER, Material.COMPARATOR, Material.PISTON, Material.STICKY_PISTON, Material.OBSERVER, Material.HOPPER, Material.DROPPER, Material.DISPENSER, Material.LEVER, Material.STONE_BUTTON, Material.TRIPWIRE_HOOK, Material.DAYLIGHT_DETECTOR, Material.NOTE_BLOCK, Material.JUKEBOX, Material.TNT, Material.TARGET, Material.SCULK_SENSOR));
        CATEGORIES.put("Decorations", Arrays.asList(Material.TORCH, Material.LANTERN, Material.SOUL_LANTERN, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.CANDLE, Material.PAINTING, Material.ITEM_FRAME, Material.GLOW_ITEM_FRAME, Material.FLOWER_POT, Material.ARMOR_STAND, Material.END_CRYSTAL, Material.BELL, Material.CHAIN, Material.LIGHTNING_ROD, Material.GLASS, Material.TINTED_GLASS, Material.SEA_LANTERN, Material.GLOWSTONE));
        CATEGORIES.put("Magic", Arrays.asList(Material.ENCHANTING_TABLE, Material.ANVIL, Material.GRINDSTONE, Material.EXPERIENCE_BOTTLE, Material.BLAZE_ROD, Material.BLAZE_POWDER, Material.ENDER_PEARL, Material.ENDER_EYE, Material.GHAST_TEAR, Material.NETHER_WART, Material.BREWING_STAND, Material.CAULDRON, Material.DRAGON_BREATH, Material.RABBIT_FOOT, Material.FERMENTED_SPIDER_EYE, Material.GLISTERING_MELON_SLICE, Material.GOLDEN_CARROT, Material.MAGMA_CREAM, Material.PHANTOM_MEMBRANE, Material.TURTLE_HELMET));
        CATEGORIES.put("Rare", Arrays.asList(Material.NETHER_STAR, Material.BEACON, Material.DRAGON_EGG, Material.ELYTRA, Material.TOTEM_OF_UNDYING, Material.SHULKER_SHELL, Material.SHULKER_BOX, Material.HEART_OF_THE_SEA, Material.CONDUIT, Material.TRIDENT, Material.MUSIC_DISC_13, Material.MUSIC_DISC_CAT, Material.SPONGE, Material.WET_SPONGE, Material.WITHER_SKELETON_SKULL, Material.DRAGON_HEAD, Material.PIGLIN_HEAD, Material.END_PORTAL_FRAME));
    }
}

