/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.gui;

import fr.skynex.myEconomy.MyEconomy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GUIConfig {
    private final MyEconomy plugin;
    private FileConfiguration config;
    private File configFile;

    public GUIConfig(MyEconomy plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.configFile = new File(this.plugin.getDataFolder(), "gui.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveResource("gui.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public Material getBorderMaterial() {
        String mat = this.config.getString("global.border-material", "GRAY_STAINED_GLASS_PANE");
        try {
            return Material.valueOf((String)mat.toUpperCase());
        }
        catch (Exception e) {
            return Material.GRAY_STAINED_GLASS_PANE;
        }
    }

    public boolean isSoundsEnabled() {
        return this.config.getBoolean("global.sounds-enabled", true);
    }

    private Sound getSound(String soundName, Sound defaultSound) {
        if (soundName == null || soundName.isEmpty()) {
            return defaultSound;
        }
        try {
            String key = soundName.toLowerCase().replace("_", ".");
            Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.minecraft((String)key));
            return sound != null ? sound : defaultSound;
        }
        catch (Exception e) {
            return defaultSound;
        }
    }

    public boolean isAnimationsEnabled() {
        return this.config.getBoolean("global.animations", false);
    }

    public String getMainMenuTitle() {
        return this.colorize(this.config.getString("main-menu.title", "&6&lMyEconomy"));
    }

    public int getMainMenuSize() {
        return this.config.getInt("main-menu.size", 54);
    }

    public int getFortuneSlot() {
        return this.config.getInt("main-menu.fortune.slot", 4);
    }

    public Material getFortuneMaterial() {
        return this.getMaterial("main-menu.fortune.material", Material.GOLD_BLOCK);
    }

    public String getFortuneName() {
        return this.colorize(this.config.getString("main-menu.fortune.name", "&6&lYour Fortune"));
    }

    public List<String> getFortuneLore() {
        return this.colorizeList(this.config.getStringList("main-menu.fortune.lore"));
    }

    public int getPaySlot() {
        return this.config.getInt("main-menu.pay.slot", 19);
    }

    public Material getPayMaterial() {
        return this.getMaterial("main-menu.pay.material", Material.EMERALD);
    }

    public String getPayName() {
        return this.colorize(this.config.getString("main-menu.pay.name", "&a&lPay"));
    }

    public List<String> getPayLore() {
        return this.colorizeList(this.config.getStringList("main-menu.pay.lore"));
    }

    public Sound getPaySound() {
        return this.getSound(this.config.getString("main-menu.pay.sound", "block.amethyst_block.step"), Sound.UI_BUTTON_CLICK);
    }

    public Sound getFortuneSound() {
        return this.getSound(this.config.getString("main-menu.fortune.sound", "block.amethyst_block.hit"), Sound.UI_BUTTON_CLICK);
    }

    public int getTopGlobalSlot() {
        return this.config.getInt("main-menu.top-global.slot", 21);
    }

    public Material getTopGlobalMaterial() {
        return this.getMaterial("main-menu.top-global.material", Material.DIAMOND);
    }

    public String getTopGlobalName() {
        return this.colorize(this.config.getString("main-menu.top-global.name", "&b&lGlobal Top"));
    }

    public List<String> getTopGlobalLore() {
        return this.colorizeList(this.config.getStringList("main-menu.top-global.lore"));
    }

    public Sound getTopGlobalSound() {
        return this.getSound(this.config.getString("main-menu.top-global.sound", "entity.experience_orb.pickup"), Sound.UI_BUTTON_CLICK);
    }

    public int getTopWeeklySlot() {
        return this.config.getInt("main-menu.top-weekly.slot", 23);
    }

    public Material getTopWeeklyMaterial() {
        return this.getMaterial("main-menu.top-weekly.material", Material.GOLDEN_APPLE);
    }

    public String getTopWeeklyName() {
        return this.colorize(this.config.getString("main-menu.top-weekly.name", "&e&lWeekly Top"));
    }

    public List<String> getTopWeeklyLore() {
        return this.colorizeList(this.config.getStringList("main-menu.top-weekly.lore"));
    }

    public Sound getTopWeeklySound() {
        return this.getSound(this.config.getString("main-menu.top-weekly.sound", "entity.experience_orb.pickup"), Sound.UI_BUTTON_CLICK);
    }

    public int getTopMonthlySlot() {
        return this.config.getInt("main-menu.top-monthly.slot", 25);
    }

    public Material getTopMonthlyMaterial() {
        return this.getMaterial("main-menu.top-monthly.material", Material.NETHER_STAR);
    }

    public String getTopMonthlyName() {
        return this.colorize(this.config.getString("main-menu.top-monthly.name", "&d&lMonthly Top"));
    }

    public List<String> getTopMonthlyLore() {
        return this.colorizeList(this.config.getStringList("main-menu.top-monthly.lore"));
    }

    public Sound getTopMonthlySound() {
        return this.getSound(this.config.getString("main-menu.top-monthly.sound", "entity.experience_orb.pickup"), Sound.UI_BUTTON_CLICK);
    }

    public int getAdminSlot() {
        return this.config.getInt("main-menu.admin.slot", 49);
    }

    public Material getAdminMaterial() {
        return this.getMaterial("main-menu.admin.material", Material.COMMAND_BLOCK);
    }

    public String getAdminName() {
        return this.colorize(this.config.getString("main-menu.admin.name", "&c&lAdmin"));
    }

    public List<String> getAdminLore() {
        return this.colorizeList(this.config.getStringList("main-menu.admin.lore"));
    }

    public Sound getAdminButtonSound() {
        return this.getSound(this.config.getString("main-menu.admin.sound", "block.note_block.pling"), Sound.UI_BUTTON_CLICK);
    }

    public Sound getCloseSound() {
        return this.getSound(this.config.getString("main-menu.close.sound", "block.wooden_door.close"), Sound.UI_BUTTON_CLICK);
    }

    public int getCloseSlot() {
        return this.config.getInt("main-menu.close.slot", 53);
    }

    public Material getCloseMaterial() {
        return this.getMaterial("main-menu.close.material", Material.BARRIER);
    }

    public String getCloseName() {
        return this.colorize(this.config.getString("main-menu.close.name", "&c&lClose"));
    }

    public int getCategorySlot(String category) {
        return this.config.getInt("main-menu.categories." + category.toLowerCase() + ".slot", 0);
    }

    public Material getCategoryMaterial(String category) {
        String path = "main-menu.categories." + category.toLowerCase() + ".material";
        return this.getMaterial(path, Material.STONE);
    }

    public String getCategoryName(String category) {
        return this.colorize(this.config.getString("main-menu.categories." + category.toLowerCase() + ".name", "&7" + category));
    }

    public List<String> getCategoryLore(String category) {
        return this.colorizeList(this.config.getStringList("main-menu.categories." + category.toLowerCase() + ".lore"));
    }

    public Sound getCategorySound(String category) {
        String path = "main-menu.categories." + category.toLowerCase() + ".sound";
        return this.getSound(this.config.getString(path, "ui.button.click"), Sound.UI_BUTTON_CLICK);
    }

    public String getRankingsTitle(String type) {
        return this.colorize(this.config.getString("rankings-menu." + type + ".title", "&b&lRanking"));
    }

    public int getRankingsSize() {
        return this.config.getInt("rankings-menu.global.size", 54);
    }

    public List<Integer> getRankingsSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (Object obj : this.config.getList("rankings-menu.positions", new ArrayList())) {
            Map map;
            if (!(obj instanceof Map) || !(map = (Map)obj).containsKey("slot")) continue;
            slots.add((Integer)map.get("slot"));
        }
        if (slots.isEmpty()) {
            slots.addAll(List.of(Integer.valueOf(19), Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23), Integer.valueOf(24), Integer.valueOf(25), Integer.valueOf(28), Integer.valueOf(29), Integer.valueOf(30)));
        }
        return slots;
    }

    public String getRankingColor(int position) {
        return this.colorize(this.config.getString("rankings-menu.colors." + position, "&7"));
    }

    public Material getRankingMaterial(int position) {
        return this.getMaterial("rankings-menu.materials." + position, Material.IRON_INGOT);
    }

    public String getRankingEntryName() {
        return this.colorize(this.config.getString("rankings-menu.entry.name", "{color}#{position} {player}"));
    }

    public List<String> getRankingEntryLore() {
        return this.colorizeList(this.config.getStringList("rankings-menu.entry.lore"));
    }

    public Sound getRankingPositionSound(int position) {
        String path = "rankings-menu.position-config." + position + ".sound";
        return this.getSound(this.config.getString(path, "entity.experience_orb.pickup"), Sound.ENTITY_EXPERIENCE_ORB_PICKUP);
    }

    public Sound getTransactionSuccessSound() {
        return this.getSound(this.config.getString("special-sounds.transaction-success", "entity.player.levelup"), Sound.ENTITY_PLAYER_LEVELUP);
    }

    public Sound getTransactionErrorSound() {
        return this.getSound(this.config.getString("special-sounds.transaction-error", "entity.villager.no"), Sound.ENTITY_VILLAGER_NO);
    }

    public Sound getMoneyReceivedSound() {
        return this.getSound(this.config.getString("special-sounds.money-received", "block.note_block.bell"), Sound.ENTITY_PLAYER_LEVELUP);
    }

    public Sound getMoneySentSound() {
        return this.getSound(this.config.getString("special-sounds.money-sent", "entity.item.pickup"), Sound.ENTITY_ITEM_PICKUP);
    }

    public Sound getRankingRewardSound() {
        return this.getSound(this.config.getString("special-sounds.ranking-reward", "ui.toast.challenge_complete"), Sound.ENTITY_PLAYER_LEVELUP);
    }

    public Sound getPayAmountSound() {
        return this.getSound(this.config.getString("pay-amount-menu.amount-sound", "block.note_block.harp"), Sound.UI_BUTTON_CLICK);
    }

    public Sound getPayConfirmSound() {
        return this.getSound(this.config.getString("pay-amount-menu.confirm-sound", "entity.player.levelup"), Sound.ENTITY_PLAYER_LEVELUP);
    }

    public Sound getAdminAmountSound() {
        return this.getSound(this.config.getString("admin-amount-menu.amount-sound", "block.note_block.harp"), Sound.UI_BUTTON_CLICK);
    }

    public Sound getAdminConfirmSound() {
        return this.getSound(this.config.getString("admin-amount-menu.confirm-sound", "entity.player.levelup"), Sound.ENTITY_PLAYER_LEVELUP);
    }

    public String getPayMenuTitle() {
        return this.colorize(this.config.getString("pay-menu.title", "&a&lPay a Player"));
    }

    public int getPayMenuSize() {
        return this.config.getInt("pay-menu.size", 54);
    }

    public String getPayAmountMenuTitle() {
        return this.colorize(this.config.getString("pay-amount-menu.title", "&a&lPay {player}"));
    }

    public String getAdminMenuTitle() {
        return this.colorize(this.config.getString("admin-menu.title", "&c&lAdministration"));
    }

    public int getAdminMenuSize() {
        return this.config.getInt("admin-menu.size", 45);
    }

    public String getMarketMenuTitle() {
        return this.colorize(this.config.getString("market-menu.title", "&a&lMarket - {category}"));
    }

    public List<String> getMarketItemLore() {
        return this.colorizeList(this.config.getStringList("market-menu.item.lore"));
    }

    private Material getMaterial(String path, Material defaultMat) {
        String mat = this.config.getString(path, defaultMat.name());
        try {
            return Material.valueOf((String)mat.toUpperCase());
        }
        catch (Exception e) {
            return defaultMat;
        }
    }

    private String colorize(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "\u00a7");
    }

    private List<String> colorizeList(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        if (list == null) {
            return result;
        }
        for (String line : list) {
            result.add(this.colorize(line));
        }
        return result;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

