/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.commands;

import fr.skynex.myEconomy.EconomyManager;
import fr.skynex.myEconomy.MyEconomy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class BaltopCommand
implements CommandExecutor {
    private final EconomyManager economyManager;
    private final MyEconomy plugin;
    private static final int DEFAULT_LIMIT = 10;

    public BaltopCommand(EconomyManager economyManager) {
        this.economyManager = economyManager;
        this.plugin = MyEconomy.getInstance();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("myeconomy.baltop")) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-no-permission"));
            return true;
        }
        int limit = 10;
        String period = null;
        if (args.length > 0) {
            String firstArg = args[0].toLowerCase();
            if (firstArg.equals("weekly") || firstArg.equals("monthly")) {
                period = firstArg;
                if (args.length > 1) {
                    try {
                        limit = Integer.parseInt(args[1]);
                        if (limit <= 0 || limit > 100) {
                            sender.sendMessage(this.plugin.getLanguageManager().getMessage("baltop-invalid-number"));
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.plugin.getLanguageManager().getMessage("baltop-usage"));
                        return true;
                    }
                }
            } else {
                try {
                    limit = Integer.parseInt(firstArg);
                    if (limit <= 0 || limit > 100) {
                        sender.sendMessage(this.plugin.getLanguageManager().getMessage("baltop-invalid-number"));
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("baltop-usage"));
                    return true;
                }
            }
        }
        Map<UUID, Double> topBalances = this.economyManager.getTopBalances(limit, period);
        String currency = this.plugin.getConfigManager().getCurrencyPlural();
        if (topBalances.isEmpty()) {
            HashMap<String, String> noPlayersPlaceholders = new HashMap<String, String>();
            noPlayersPlaceholders.put("prefix", this.plugin.getLanguageManager().getMessage("prefix"));
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("baltop-no-players", noPlayersPlaceholders));
            return true;
        }
        HashMap<String, String> titlePlaceholders = new HashMap<String, String>();
        titlePlaceholders.put("number", String.valueOf(limit));
        String title = period != null ? (period.equals("weekly") ? this.plugin.getLanguageManager().getMessage("baltop-title-weekly", titlePlaceholders) : this.plugin.getLanguageManager().getMessage("baltop-title-monthly", titlePlaceholders)) : this.plugin.getLanguageManager().getMessage("baltop-title-all", titlePlaceholders);
        sender.sendMessage(title);
        int position = 1;
        for (Map.Entry<UUID, Double> entry : topBalances.entrySet()) {
            String playerName = this.plugin.getServer().getOfflinePlayer(entry.getKey()).getName();
            if (playerName == null) {
                playerName = "Unknown player";
            }
            String color = this.getPositionColor(position);
            HashMap<String, String> linePlaceholders = new HashMap<String, String>();
            linePlaceholders.put("color", color);
            linePlaceholders.put("position", String.valueOf(position));
            linePlaceholders.put("player", playerName);
            linePlaceholders.put("balance", String.format("%.2f", entry.getValue()));
            linePlaceholders.put("coins", currency);
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("baltop-line", linePlaceholders));
            ++position;
        }
        sender.sendMessage(this.plugin.getLanguageManager().getMessage("baltop-footer"));
        return true;
    }

    private String getPositionColor(int position) {
        switch (position) {
            case 1: {
                return "\u00a76\u00a7l";
            }
            case 2: {
                return "\u00a77\u00a7l";
            }
            case 3: {
                return "\u00a7c\u00a7l";
            }
        }
        return "\u00a77";
    }
}

