/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.database.DatabaseManager;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class StatsManager {
    private final MyEconomy plugin;
    private File statsFile;
    private FileConfiguration statsConfig;

    public StatsManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.setupStatsFile();
    }

    private void setupStatsFile() {
        this.statsFile = new File(this.plugin.getDataFolder(), "stats.yml");
        if (!this.statsFile.exists()) {
            try {
                this.statsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Unable to create stats.yml file");
                e.printStackTrace();
            }
        }
        this.statsConfig = YamlConfiguration.loadConfiguration((File)this.statsFile);
    }

    public void recordTransaction(UUID uuid, double amount, String type) {
        String dbType = this.plugin.getConfigManager().getDatabaseType().toLowerCase();
        if (dbType.equals("mysql") || dbType.equals("sqlite")) {
            this.recordTransactionSQL(uuid, amount, type);
        } else {
            this.recordTransactionYAML(uuid, amount, type);
        }
    }

    private void recordTransactionYAML(UUID uuid, double amount, String type) {
        String path = "stats." + uuid.toString() + ".";
        if (type.equals("earned") || type.equals("received")) {
            current = this.statsConfig.getDouble(path + "total_earned", 0.0);
            this.statsConfig.set(path + "total_earned", (Object)(current + amount));
        } else if (type.equals("spent") || type.equals("sent")) {
            current = this.statsConfig.getDouble(path + "total_spent", 0.0);
            this.statsConfig.set(path + "total_spent", (Object)(current + amount));
        }
        int count = this.statsConfig.getInt(path + "transactions_count", 0);
        this.statsConfig.set(path + "transactions_count", (Object)(count + 1));
        this.saveStats();
    }

    private void recordTransactionSQL(UUID uuid, double amount, String type) {
        DatabaseManager db = this.plugin.getDatabaseManager();
        if (!db.isConnected()) {
            return;
        }
        boolean sqlite = this.plugin.getConfigManager().getDatabaseType().equalsIgnoreCase("sqlite");
        try (Connection conn = db.getConnection();){
            String updateStats = sqlite ? "INSERT INTO stats (uuid, total_earned, total_spent, transactions_count) VALUES (?, ?, ?, 1) ON CONFLICT(uuid) DO UPDATE SET total_earned = total_earned + excluded.total_earned, total_spent = total_spent + excluded.total_spent, transactions_count = transactions_count + 1" : "INSERT INTO stats (uuid, total_earned, total_spent, transactions_count) VALUES (?, ?, ?, 1) ON DUPLICATE KEY UPDATE total_earned = total_earned + ?, total_spent = total_spent + ?, transactions_count = transactions_count + 1";
            try (PreparedStatement stmt = conn.prepareStatement(updateStats);){
                double earned = type.equals("earned") || type.equals("received") ? amount : 0.0;
                double spent = type.equals("spent") || type.equals("sent") ? amount : 0.0;
                stmt.setString(1, uuid.toString());
                stmt.setDouble(2, earned);
                stmt.setDouble(3, spent);
                if (!sqlite) {
                    stmt.setDouble(4, earned);
                    stmt.setDouble(5, spent);
                }
                stmt.executeUpdate();
            }
            String insertTransaction = "INSERT INTO transactions (from_uuid, to_uuid, amount, type, timestamp) VALUES (?, ?, ?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(insertTransaction);){
                if (type.equals("sent") || type.equals("spent")) {
                    stmt.setString(1, uuid.toString());
                    stmt.setString(2, null);
                } else {
                    stmt.setString(1, null);
                    stmt.setString(2, uuid.toString());
                }
                stmt.setDouble(3, amount);
                stmt.setString(4, type);
                stmt.setLong(5, System.currentTimeMillis());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error recording MySQL stats: " + e.getMessage());
        }
    }

    public PlayerStats getStats(UUID uuid) {
        String dbType = this.plugin.getConfigManager().getDatabaseType().toLowerCase();
        if (dbType.equals("mysql") || dbType.equals("sqlite")) {
            return this.getStatsSQL(uuid);
        }
        return this.getStatsYAML(uuid);
    }

    private PlayerStats getStatsYAML(UUID uuid) {
        String path = "stats." + uuid.toString() + ".";
        return new PlayerStats(this.statsConfig.getDouble(path + "total_earned", 0.0), this.statsConfig.getDouble(path + "total_spent", 0.0), this.statsConfig.getInt(path + "transactions_count", 0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PlayerStats getStatsSQL(UUID uuid) {
        DatabaseManager db = this.plugin.getDatabaseManager();
        if (!db.isConnected()) {
            return new PlayerStats(0.0, 0.0, 0);
        }
        try (Connection conn = db.getConnection();){
            String sql = "SELECT total_earned, total_spent, transactions_count FROM stats WHERE uuid = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return new PlayerStats(0.0, 0.0, 0);
                    PlayerStats playerStats = new PlayerStats(rs.getDouble("total_earned"), rs.getDouble("total_spent"), rs.getInt("transactions_count"));
                    return playerStats;
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving MySQL stats: " + e.getMessage());
        }
        return new PlayerStats(0.0, 0.0, 0);
    }

    private void saveStats() {
        try {
            this.statsConfig.save(this.statsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Unable to save stats.yml");
            e.printStackTrace();
        }
    }

    public double getTotalTransactionsValue() {
        double total;
        block25: {
            total = 0.0;
            String dbType = this.plugin.getConfigManager().getDatabaseType().toLowerCase();
            if (dbType.equals("mysql") || dbType.equals("sqlite")) {
                DatabaseManager db = this.plugin.getDatabaseManager();
                if (db.isConnected()) {
                    try (Connection conn = db.getConnection();){
                        String sql = "SELECT SUM(total_earned + total_spent) as total FROM stats";
                        try (PreparedStatement stmt = conn.prepareStatement(sql);
                             ResultSet rs = stmt.executeQuery();){
                            if (!rs.next()) break block25;
                            total = rs.getDouble("total");
                        }
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().severe("Error calculating GDP: " + e.getMessage());
                    }
                }
            } else if (this.statsConfig.getConfigurationSection("stats") != null) {
                for (String key : this.statsConfig.getConfigurationSection("stats").getKeys(false)) {
                    String path = "stats." + key + ".";
                    total += this.statsConfig.getDouble(path + "total_earned", 0.0);
                    total += this.statsConfig.getDouble(path + "total_spent", 0.0);
                }
            }
        }
        return total;
    }

    public List<TransactionRecord> getPlayerTransactions(UUID uuid, int limit) {
        ArrayList<TransactionRecord> result = new ArrayList<TransactionRecord>();
        if (!this.plugin.getConfigManager().getDatabaseType().equals("mysql") && !this.plugin.getConfigManager().getDatabaseType().equals("sqlite")) {
            return result;
        }
        DatabaseManager db = this.plugin.getDatabaseManager();
        if (!db.isConnected()) {
            return result;
        }
        try (Connection conn = db.getConnection();){
            String sql = "SELECT from_uuid, to_uuid, amount, type, timestamp FROM transactions WHERE from_uuid = ? OR to_uuid = ? ORDER BY timestamp DESC LIMIT ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                String uuidStr = uuid.toString();
                stmt.setString(1, uuidStr);
                stmt.setString(2, uuidStr);
                stmt.setInt(3, limit);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        String fromUuid = rs.getString("from_uuid");
                        String toUuid = rs.getString("to_uuid");
                        double amount = rs.getDouble("amount");
                        String type = rs.getString("type");
                        long timestamp = rs.getLong("timestamp");
                        boolean isIncoming = uuidStr.equals(toUuid);
                        result.add(new TransactionRecord(fromUuid, toUuid, amount, type, timestamp, isIncoming));
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting player transactions: " + e.getMessage());
        }
        return result;
    }

    public int getTotalTransactionsCount() {
        int total;
        block25: {
            total = 0;
            String dbType = this.plugin.getConfigManager().getDatabaseType().toLowerCase();
            if (dbType.equals("mysql") || dbType.equals("sqlite")) {
                DatabaseManager db = this.plugin.getDatabaseManager();
                if (db.isConnected()) {
                    try (Connection conn = db.getConnection();){
                        String sql = "SELECT SUM(transactions_count) as total FROM stats";
                        try (PreparedStatement stmt = conn.prepareStatement(sql);
                             ResultSet rs = stmt.executeQuery();){
                            if (!rs.next()) break block25;
                            total = rs.getInt("total");
                        }
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().severe("Error calculating transaction count: " + e.getMessage());
                    }
                }
            } else if (this.statsConfig.getConfigurationSection("stats") != null) {
                for (String key : this.statsConfig.getConfigurationSection("stats").getKeys(false)) {
                    String path = "stats." + key + ".";
                    total += this.statsConfig.getInt(path + "transactions_count", 0);
                }
            }
        }
        return total;
    }

    public static class PlayerStats {
        private final double totalEarned;
        private final double totalSpent;
        private final int transactionsCount;

        public PlayerStats(double totalEarned, double totalSpent, int transactionsCount) {
            this.totalEarned = totalEarned;
            this.totalSpent = totalSpent;
            this.transactionsCount = transactionsCount;
        }

        public double getTotalEarned() {
            return this.totalEarned;
        }

        public double getTotalSpent() {
            return this.totalSpent;
        }

        public int getTransactionsCount() {
            return this.transactionsCount;
        }
    }

    public static class TransactionRecord {
        private final String fromUuid;
        private final String toUuid;
        private final double amount;
        private final String type;
        private final long timestamp;
        private final boolean incoming;

        public TransactionRecord(String fromUuid, String toUuid, double amount, String type, long timestamp, boolean incoming) {
            this.fromUuid = fromUuid;
            this.toUuid = toUuid;
            this.amount = amount;
            this.type = type;
            this.timestamp = timestamp;
            this.incoming = incoming;
        }

        public String getFromUuid() {
            return this.fromUuid;
        }

        public String getToUuid() {
            return this.toUuid;
        }

        public double getAmount() {
            return this.amount;
        }

        public String getType() {
            return this.type;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean isIncoming() {
            return this.incoming;
        }
    }
}

