/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.database.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class RankingManager {
    private final MyEconomy plugin;
    private BukkitTask rankingTask;

    public RankingManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.startRankingUpdates();
    }

    private void startRankingUpdates() {
        int intervalMinutes = this.plugin.getConfigManager().getWeeklyRankingUpdateInterval();
        this.rankingTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.updateRankings(), 0L, 1200L * (long)intervalMinutes);
    }

    public void updateRankings() {
        String dbType = this.plugin.getConfigManager().getDatabaseType().toLowerCase();
        if (dbType.equals("mysql") || dbType.equals("sqlite")) {
            this.updateRankingsSQL();
        }
        this.checkAndDistributeRewards();
    }

    private void updateRankingsSQL() {
        block23: {
            DatabaseManager db = this.plugin.getDatabaseManager();
            if (!db.isConnected()) {
                return;
            }
            boolean sqlite = this.plugin.getConfigManager().getDatabaseType().equalsIgnoreCase("sqlite");
            try (Connection conn = db.getConnection();){
                PreparedStatement stmt;
                String sql;
                if (this.plugin.getConfigManager().isWeeklyRankingEnabled()) {
                    long weekStart = this.getWeekStartTimestamp();
                    sql = sqlite ? "INSERT OR REPLACE INTO weekly_rankings (uuid, balance, week_start) SELECT uuid, balance, ? FROM balances" : "INSERT INTO weekly_rankings (uuid, balance, week_start) SELECT uuid, balance, ? FROM balances ON DUPLICATE KEY UPDATE balance = VALUES(balance), week_start = VALUES(week_start)";
                    stmt = conn.prepareStatement(sql);
                    try {
                        stmt.setLong(1, weekStart);
                        stmt.executeUpdate();
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                if (!this.plugin.getConfigManager().isMonthlyRankingEnabled()) break block23;
                long monthStart = this.getMonthStartTimestamp();
                sql = sqlite ? "INSERT OR REPLACE INTO monthly_rankings (uuid, balance, month_start) SELECT uuid, balance, ? FROM balances" : "INSERT INTO monthly_rankings (uuid, balance, month_start) SELECT uuid, balance, ? FROM balances ON DUPLICATE KEY UPDATE balance = VALUES(balance), month_start = VALUES(month_start)";
                stmt = conn.prepareStatement(sql);
                try {
                    stmt.setLong(1, monthStart);
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error updating rankings: " + e.getMessage());
            }
        }
    }

    private long getWeekStartTimestamp() {
        LocalDate now = LocalDate.now();
        DayOfWeek resetDay = DayOfWeek.valueOf(this.plugin.getConfigManager().getWeeklyResetDay().toUpperCase());
        LocalDate weekStart = now.with(TemporalAdjusters.previousOrSame(resetDay));
        return weekStart.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    private long getMonthStartTimestamp() {
        LocalDate now = LocalDate.now();
        int resetDay = this.plugin.getConfigManager().getMonthlyResetDay();
        LocalDate monthStart = now.withDayOfMonth(Math.min(resetDay, now.lengthOfMonth()));
        if (now.getDayOfMonth() < resetDay) {
            monthStart = monthStart.minusMonths(1L);
        }
        return monthStart.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    private void checkAndDistributeRewards() {
    }

    public void distributeWeeklyRewards() {
        if (!this.plugin.getConfigManager().isWeeklyRewardsEnabled()) {
            return;
        }
        Map<UUID, Double> top = this.plugin.getEconomyManager().getTopBalances(3, "weekly");
        int position = 1;
        for (Map.Entry<UUID, Double> entry : top.entrySet()) {
            double reward = this.plugin.getConfigManager().getWeeklyReward(position);
            if (reward > 0.0) {
                this.plugin.getEconomyManager().addBalance(entry.getKey(), reward);
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)entry.getKey());
                String playerName = player.getName();
                if (player.isOnline()) {
                    Player onlinePlayer = player.getPlayer();
                    HashMap<String, String> rewardPlaceholders = new HashMap<String, String>();
                    rewardPlaceholders.put("amount", String.format("%.2f", reward));
                    rewardPlaceholders.put("position", String.valueOf(position));
                    rewardPlaceholders.put("coins", this.plugin.getConfigManager().getCurrencyPlural());
                    onlinePlayer.sendMessage(this.plugin.getLanguageManager().getMessage("ranking-weekly-reward", rewardPlaceholders));
                    this.plugin.getNotificationManager().sendRankingReward(onlinePlayer, position, reward, "weekly");
                }
                if (playerName != null) {
                    this.plugin.getDiscordWebhook().sendRankingReward(playerName, position, reward, "weekly");
                }
            }
            ++position;
        }
    }

    public void distributeMonthlyRewards() {
        if (!this.plugin.getConfigManager().isMonthlyRewardsEnabled()) {
            return;
        }
        Map<UUID, Double> top = this.plugin.getEconomyManager().getTopBalances(3, "monthly");
        int position = 1;
        for (Map.Entry<UUID, Double> entry : top.entrySet()) {
            double reward = this.plugin.getConfigManager().getMonthlyReward(position);
            if (reward > 0.0) {
                this.plugin.getEconomyManager().addBalance(entry.getKey(), reward);
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)entry.getKey());
                String playerName = player.getName();
                if (player.isOnline()) {
                    Player onlinePlayer = player.getPlayer();
                    HashMap<String, String> rewardPlaceholders = new HashMap<String, String>();
                    rewardPlaceholders.put("amount", String.format("%.2f", reward));
                    rewardPlaceholders.put("position", String.valueOf(position));
                    rewardPlaceholders.put("coins", this.plugin.getConfigManager().getCurrencyPlural());
                    onlinePlayer.sendMessage(this.plugin.getLanguageManager().getMessage("ranking-monthly-reward", rewardPlaceholders));
                    this.plugin.getNotificationManager().sendRankingReward(onlinePlayer, position, reward, "monthly");
                }
                if (playerName != null) {
                    this.plugin.getDiscordWebhook().sendRankingReward(playerName, position, reward, "monthly");
                }
            }
            ++position;
        }
    }

    public void shutdown() {
        if (this.rankingTask != null) {
            this.rankingTask.cancel();
        }
    }

    public List<Map.Entry<UUID, Double>> getTopBalances(int limit) {
        Map<UUID, Double> top = this.plugin.getEconomyManager().getTopBalances(limit);
        return new ArrayList<Map.Entry<UUID, Double>>(top.entrySet());
    }

    public List<Map.Entry<UUID, Double>> getWeeklyTop(int limit) {
        Map<UUID, Double> top = this.plugin.getEconomyManager().getTopBalances(limit, "weekly");
        return new ArrayList<Map.Entry<UUID, Double>>(top.entrySet());
    }

    public List<Map.Entry<UUID, Double>> getMonthlyTop(int limit) {
        Map<UUID, Double> top = this.plugin.getEconomyManager().getTopBalances(limit, "monthly");
        return new ArrayList<Map.Entry<UUID, Double>>(top.entrySet());
    }
}

