/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy;

import fr.skynex.myEconomy.ConfigManager;
import fr.skynex.myEconomy.EconomyManager;
import fr.skynex.myEconomy.LanguageManager;
import fr.skynex.myEconomy.RankingManager;
import fr.skynex.myEconomy.SecurityManager;
import fr.skynex.myEconomy.StatsManager;
import fr.skynex.myEconomy.audit.AuditLogger;
import fr.skynex.myEconomy.backup.BackupManager;
import fr.skynex.myEconomy.bstats.bukkit.Metrics;
import fr.skynex.myEconomy.commands.BalanceCommand;
import fr.skynex.myEconomy.commands.BaltopCommand;
import fr.skynex.myEconomy.commands.EcoCommand;
import fr.skynex.myEconomy.commands.MenuCommand;
import fr.skynex.myEconomy.commands.PayCommand;
import fr.skynex.myEconomy.commands.TransactionsCommand;
import fr.skynex.myEconomy.database.DatabaseManager;
import fr.skynex.myEconomy.discord.DiscordWebhook;
import fr.skynex.myEconomy.gui.GUIConfig;
import fr.skynex.myEconomy.gui.MainEconomyGUI;
import fr.skynex.myEconomy.gui.MarketPricesGUI;
import fr.skynex.myEconomy.hologram.HologramManager;
import fr.skynex.myEconomy.integration.AuctionHouseIntegration;
import fr.skynex.myEconomy.integration.MyEconomyProvider;
import fr.skynex.myEconomy.market.MarketIntelligence;
import fr.skynex.myEconomy.notifications.NotificationManager;
import fr.skynex.myEconomy.placeholder.MyEconomyPlaceholders;
import fr.skynex.myEconomy.vault.MyEconomyVault;
import fr.skynex.mycore.api.MyCoreAPI;
import fr.skynex.mycore.api.economy.EconomyProvider;
import fr.skynex.mycore.api.provider.Provider;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class MyEconomy
extends JavaPlugin {
    private static MyEconomy instance;
    private ConfigManager configManager;
    private LanguageManager languageManager;
    private DatabaseManager databaseManager;
    private EconomyManager economyManager;
    private StatsManager statsManager;
    private SecurityManager securityManager;
    private RankingManager rankingManager;
    private AuditLogger auditLogger;
    private BackupManager backupManager;
    private GUIConfig guiConfig;
    private MainEconomyGUI mainEconomyGUI;
    private MarketPricesGUI marketPricesGUI;
    private AuctionHouseIntegration auctionHouseIntegration;
    private MarketIntelligence marketIntelligence;
    private NotificationManager notificationManager;
    private DiscordWebhook discordWebhook;
    private HologramManager hologramManager;

    public void onEnable() {
        instance = this;
        new Metrics(this, 29191);
        this.configManager = new ConfigManager(this);
        this.languageManager = new LanguageManager(this);
        this.databaseManager = new DatabaseManager(this);
        this.economyManager = new EconomyManager(this);
        this.statsManager = new StatsManager(this);
        this.securityManager = new SecurityManager(this);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> this.securityManager.cleanupExpiredConfirmations(), 600L, 600L);
        this.rankingManager = new RankingManager(this);
        this.auditLogger = new AuditLogger(this);
        this.backupManager = new BackupManager(this);
        this.notificationManager = new NotificationManager(this);
        this.discordWebhook = new DiscordWebhook(this);
        this.guiConfig = new GUIConfig(this);
        this.mainEconomyGUI = new MainEconomyGUI(this);
        this.marketPricesGUI = new MarketPricesGUI(this);
        if (this.configManager.isMarketLearningEnabled()) {
            this.marketIntelligence = new MarketIntelligence(this);
            this.getLogger().info("Market intelligence enabled - Automatic price learning!");
        }
        this.getCommand("balance").setExecutor((CommandExecutor)new BalanceCommand(this.economyManager));
        this.getCommand("balance").setTabCompleter((TabCompleter)new BalanceCommand(this.economyManager));
        this.getCommand("pay").setExecutor((CommandExecutor)new PayCommand(this.economyManager));
        this.getCommand("pay").setTabCompleter((TabCompleter)new PayCommand(this.economyManager));
        this.getCommand("baltop").setExecutor((CommandExecutor)new BaltopCommand(this.economyManager));
        this.getCommand("eco").setExecutor((CommandExecutor)new EcoCommand(this.economyManager));
        this.getCommand("eco").setTabCompleter((TabCompleter)new EcoCommand(this.economyManager));
        this.getCommand("ecomenu").setExecutor((CommandExecutor)new MenuCommand(this));
        this.getCommand("transactions").setExecutor((CommandExecutor)new TransactionsCommand(this));
        this.getCommand("transactions").setTabCompleter((TabCompleter)new TransactionsCommand(this));
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.getServer().getServicesManager().register(Economy.class, (Object)new MyEconomyVault(this), (Plugin)this, ServicePriority.Normal);
            this.getLogger().info("Vault integration enabled!");
        } else {
            this.getLogger().info("Vault is not installed. Vault API will not be available.");
        }
        this.getServer().getScheduler().runTask((Plugin)this, () -> {
            this.auctionHouseIntegration = new AuctionHouseIntegration(this);
        });
        this.getServer().getScheduler().runTask((Plugin)this, () -> {
            this.hologramManager = new HologramManager(this);
        });
        this.registerWithMyCore();
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new MyEconomyPlaceholders(this).register();
            this.getLogger().info("PlaceholderAPI expansion registered!");
        }
        this.getLogger().info("MyEconomy has been enabled successfully!");
    }

    public void onDisable() {
        this.unregisterFromMyCore();
        if (this.hologramManager != null) {
            this.hologramManager.shutdown();
        }
        if (this.rankingManager != null) {
            this.rankingManager.shutdown();
        }
        if (this.backupManager != null) {
            this.backupManager.shutdown();
        }
        if (this.economyManager != null) {
            this.economyManager.shutdown();
        }
        if (this.databaseManager != null) {
            this.databaseManager.disconnect();
        }
        if (this.backupManager != null) {
            this.backupManager.createBackup();
        }
        this.getLogger().info("MyEconomy has been disabled.");
    }

    public static MyEconomy getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public StatsManager getStatsManager() {
        return this.statsManager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public RankingManager getRankingManager() {
        return this.rankingManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public MainEconomyGUI getMainEconomyGUI() {
        return this.mainEconomyGUI;
    }

    public DiscordWebhook getDiscordWebhook() {
        return this.discordWebhook;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    public AuctionHouseIntegration getAuctionHouseIntegration() {
        return this.auctionHouseIntegration;
    }

    public MarketIntelligence getMarketIntelligence() {
        return this.marketIntelligence;
    }

    public MarketPricesGUI getMarketPricesGUI() {
        return this.marketPricesGUI;
    }

    public GUIConfig getGUIConfig() {
        return this.guiConfig;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    private void registerWithMyCore() {
        if (this.getServer().getPluginManager().getPlugin("MyCore") != null) {
            try {
                MyCoreAPI.register(EconomyProvider.class, (Provider)new MyEconomyProvider(this), (JavaPlugin)this);
                this.getLogger().info("Registered with MyCore ecosystem!");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register with MyCore: " + e.getMessage());
            }
        }
    }

    private void unregisterFromMyCore() {
        if (this.getServer().getPluginManager().getPlugin("MyCore") != null) {
            try {
                MyCoreAPI.unregisterAll((JavaPlugin)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

