/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy;

import fr.skynex.myEconomy.MyEconomy;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final MyEconomy plugin;
    private FileConfiguration config;

    public ConfigManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getLanguage() {
        return this.config.getString("general.language", this.config.getString("language", "en"));
    }

    public boolean isDebug() {
        return this.config.getBoolean("general.debug", false);
    }

    public String getPrefix() {
        return this.config.getString("general.prefix", "&6[MyEconomy] &7");
    }

    public String getCurrencyName() {
        return this.config.getString("currency.name", this.config.getString("currency-name", "coins"));
    }

    public String getCurrencySingular() {
        return this.config.getString("currency.singular", this.config.getString("currency-singular", "coin"));
    }

    public String getCurrencyPlural() {
        return this.config.getString("currency.plural", this.config.getString("currency-plural", "coins"));
    }

    public String getCurrencySymbol() {
        return this.config.getString("currency.symbol", "");
    }

    public int getCurrencyDecimals() {
        return this.config.getInt("currency.decimals", 2);
    }

    public boolean isShortFormatEnabled() {
        return this.config.getBoolean("currency.short-format", true);
    }

    public boolean isThousandSeparatorEnabled() {
        return this.config.getBoolean("currency.thousand-separator", false);
    }

    public String getThousandSeparator() {
        return this.config.getString("currency.thousand-separator-char", ",");
    }

    public double getStartingBalance() {
        return this.config.getDouble("starting-balance.amount", this.config.getDouble("starting-balance", 100.0));
    }

    public String getWelcomeMessage() {
        return this.config.getString("starting-balance.welcome-message", "");
    }

    public boolean isPayEnabled() {
        return this.config.getBoolean("pay.enabled", true);
    }

    public double getPayMinAmount() {
        return this.config.getDouble("pay.min-amount", 1.0);
    }

    public double getPayMaxAmount() {
        double max = this.config.getDouble("pay.max-amount", 0.0);
        return max <= 0.0 ? Double.MAX_VALUE : max;
    }

    public double getPayTaxPercentage() {
        return this.config.getDouble("pay.tax-percentage", 0.0);
    }

    public double getPayConfirmationThreshold() {
        double threshold = this.config.getDouble("pay.require-confirmation-above", 10000.0);
        return threshold <= 0.0 ? Double.MAX_VALUE : threshold;
    }

    public boolean isAllowSelfPay() {
        return this.config.getBoolean("pay.allow-self-pay", false);
    }

    public List<Integer> getPayQuickAmounts() {
        return this.config.getIntegerList("pay.quick-amounts");
    }

    public int getTopSize() {
        return this.config.getInt("rankings.top-size", 10);
    }

    public boolean isWeeklyRankingEnabled() {
        return this.config.getBoolean("rankings.weekly.enabled", true);
    }

    public String getWeeklyResetDay() {
        return this.config.getString("rankings.weekly.reset-day", "monday");
    }

    public int getWeeklyRankingUpdateInterval() {
        return this.config.getInt("rankings.weekly.update-interval", 60);
    }

    public boolean isWeeklyRewardsEnabled() {
        return this.config.getBoolean("rankings.weekly.rewards.enabled", true);
    }

    public double getWeeklyReward(int position) {
        return this.config.getDouble("rankings.weekly.rewards.positions." + position, 0.0);
    }

    public boolean isMonthlyRankingEnabled() {
        return this.config.getBoolean("rankings.monthly.enabled", true);
    }

    public int getMonthlyResetDay() {
        return this.config.getInt("rankings.monthly.reset-day", 1);
    }

    public int getMonthlyRankingUpdateInterval() {
        return this.config.getInt("rankings.monthly.update-interval", 60);
    }

    public boolean isMonthlyRewardsEnabled() {
        return this.config.getBoolean("rankings.monthly.rewards.enabled", true);
    }

    public double getMonthlyReward(int position) {
        return this.config.getDouble("rankings.monthly.rewards.positions." + position, 0.0);
    }

    public int getMaxTransactionsPerMinute() {
        return this.config.getInt("security.max-transactions-per-minute", 20);
    }

    public int getTransactionCooldown() {
        return this.config.getInt("security.transaction-cooldown", 3);
    }

    public double getMaxBalance() {
        double max = this.config.getDouble("security.max-balance", 0.0);
        return max <= 0.0 ? Double.MAX_VALUE : max;
    }

    public double getMinBalance() {
        return this.config.getDouble("security.min-balance", 0.0);
    }

    public boolean isAllowNegativeBalance() {
        return this.config.getBoolean("security.allow-negative-balance", false);
    }

    public String getDatabaseType() {
        return this.config.getString("database.type", "yaml").toLowerCase();
    }

    public String getMySQLHost() {
        return this.config.getString("database.mysql.host", "localhost");
    }

    public int getMySQLPort() {
        return this.config.getInt("database.mysql.port", 3306);
    }

    public String getMySQLDatabase() {
        return this.config.getString("database.mysql.database", "myeconomy");
    }

    public String getMySQLUsername() {
        return this.config.getString("database.mysql.username", "root");
    }

    public String getMySQLPassword() {
        return this.config.getString("database.mysql.password", "");
    }

    public boolean getMySQLUseSSL() {
        return this.config.getBoolean("database.mysql.use-ssl", false);
    }

    public String getMySQLTablePrefix() {
        return this.config.getString("database.mysql.table-prefix", "myeco_");
    }

    public String getSQLitePath() {
        return this.config.getString("database.sqlite.path", "economy.db");
    }

    public boolean isAuctionHouseEnabled() {
        return this.config.getBoolean("auction-house.enabled", true);
    }

    public boolean isAuctionHouseTrackTransactions() {
        return this.config.getBoolean("auction-house.track-transactions", true);
    }

    public boolean isAuctionHouseLogLargeTransactions() {
        return this.config.getBoolean("auction-house.log-large-transactions", true);
    }

    public double getLargeTransactionThreshold() {
        return this.config.getDouble("auction-house.large-transaction-threshold", 10000.0);
    }

    public double getAuctionHouseSaleTaxPercentage() {
        return this.config.getDouble("auction-house.sale-tax-percentage", 5.0) / 100.0;
    }

    public double getAuctionHousePurchaseTaxPercentage() {
        return this.config.getDouble("auction-house.purchase-tax-percentage", 0.0) / 100.0;
    }

    public double getAuctionHouseCommissionPercentage() {
        return this.config.getDouble("auction-house.commission-percentage", 2.0) / 100.0;
    }

    public boolean isAuctionHouseApplyTaxes() {
        return this.config.getBoolean("auction-house.apply-taxes", true);
    }

    public boolean isAuctionHouseSendNotifications() {
        return this.config.getBoolean("auction-house.send-notifications", true);
    }

    public boolean isAuctionHouseDynamicPricingEnabled() {
        return this.config.getBoolean("auction-house.dynamic-pricing.enabled", true);
    }

    public int getAuctionHouseHighSupplyThreshold() {
        return this.config.getInt("auction-house.dynamic-pricing.high-supply-threshold", 50);
    }

    public int getAuctionHouseLowSupplyThreshold() {
        return this.config.getInt("auction-house.dynamic-pricing.low-supply-threshold", 5);
    }

    public double getAuctionHouseMaxPriceMultiplier() {
        return this.config.getDouble("auction-house.dynamic-pricing.max-price-multiplier", 1.5);
    }

    public int getAuctionHousePriceUpdateInterval() {
        return this.config.getInt("auction-house.dynamic-pricing.update-interval", 5);
    }

    public boolean isAuctionHouseBlockOverpricedSales() {
        return this.config.getBoolean("auction-house.dynamic-pricing.block-overpriced-sales", false);
    }

    public boolean isMarketLearningEnabled() {
        return this.config.getBoolean("market-learning.enabled", true);
    }

    public int getMarketDataRetentionDays() {
        return this.config.getInt("market-learning.data-retention-days", 14);
    }

    public long getMarketLearningTimeWindow() {
        int days = this.getMarketDataRetentionDays();
        return (long)days * 24L * 60L * 60L * 1000L;
    }

    public long getMarketLearningCleanupInterval() {
        return this.config.getLong("market-learning.cleanup-interval", 3600L);
    }

    public boolean isMarketLearningTrackAuctionHouse() {
        return this.config.getBoolean("market-learning.track-sources.auction-house", true);
    }

    public boolean isMarketLearningTrackPlayerTrades() {
        return this.config.getBoolean("market-learning.track-sources.player-trades", true);
    }

    public boolean isMarketLearningTrackShops() {
        return this.config.getBoolean("market-learning.track-sources.shops", true);
    }

    public boolean isMarketLearningTrackAdminGive() {
        return this.config.getBoolean("market-learning.track-sources.admin-give", false);
    }

    public boolean isBackupEnabled() {
        return this.config.getBoolean("backup.enabled", true);
    }

    public int getBackupInterval() {
        return this.config.getInt("backup.interval-hours", 6);
    }

    public int getMaxBackupsToKeep() {
        return this.config.getInt("backup.max-backups", 10);
    }

    public boolean isBackupCompress() {
        return this.config.getBoolean("backup.compress", true);
    }

    public boolean isDiscordEnabled() {
        return this.config.getBoolean("discord.enabled", false);
    }

    public String getDiscordWebhookUrl() {
        return this.config.getString("discord.webhook-url", "");
    }

    public boolean isDiscordNotifyLargeTransactions() {
        return this.config.getBoolean("discord.events.large-transactions", true);
    }

    public boolean isDiscordNotifyRankingRewards() {
        return this.config.getBoolean("discord.events.ranking-rewards", true);
    }

    public boolean isDiscordNotifyAdminActions() {
        return this.config.getBoolean("discord.events.admin-actions", true);
    }

    public int getBalanceCacheTTL() {
        return this.config.getInt("cache.balance-ttl", 30);
    }

    public int getCacheCleanupInterval() {
        return this.config.getInt("cache.cleanup-interval", 1);
    }

    public boolean isNotificationsEnabled() {
        return this.config.getBoolean("notifications.enabled", true);
    }

    public long getNotificationDelay() {
        return this.config.getLong("notifications.delay-ticks", 20L);
    }

    public boolean isNotifyPaymentReceived() {
        return this.config.getBoolean("notifications.types.payment-received", true);
    }

    public boolean isNotifyRankingReward() {
        return this.config.getBoolean("notifications.types.ranking-reward", true);
    }

    public boolean isNotifyAuctionSale() {
        return this.config.getBoolean("notifications.types.auction-sale", true);
    }

    public boolean isGuiAnimations() {
        return this.config.getBoolean("gui.animations", false);
    }

    public String getGuiBorderColor() {
        return this.config.getString("gui.border-color", "GRAY_STAINED_GLASS_PANE");
    }

    public boolean isGuiSoundOpenMenu() {
        return this.config.getBoolean("gui.sounds.open-menu", true);
    }

    public boolean isGuiSoundClick() {
        return this.config.getBoolean("gui.sounds.click", true);
    }

    public boolean isGuiSoundTransaction() {
        return this.config.getBoolean("gui.sounds.transaction", true);
    }
}

