/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.utils;

import fr.skynex.mycommands.exceptions.ValidationException;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class Validator {
    private static final Pattern HOME_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{3,16}$");
    private static final Pattern WARP_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{3,32}$");
    private static final Pattern NICKNAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_&]{3,16}$");
    private static final int MIN_HOME_NAME_LENGTH = 3;
    private static final int MAX_HOME_NAME_LENGTH = 16;
    private static final int MIN_WARP_NAME_LENGTH = 3;
    private static final int MAX_WARP_NAME_LENGTH = 32;
    private static final int MIN_NICKNAME_LENGTH = 3;
    private static final int MAX_NICKNAME_LENGTH = 16;

    private Validator() {
        throw new UnsupportedOperationException("This is a utility class");
    }

    public static boolean isValidHomeName(String homeName) {
        return homeName != null && homeName.length() >= 3 && homeName.length() <= 16 && HOME_NAME_PATTERN.matcher(homeName).matches();
    }

    public static void validateHomeName(String homeName) throws ValidationException {
        if (homeName == null) {
            throw new ValidationException("homeName", null, "validation.home-name-invalid");
        }
        if (homeName.length() < 3) {
            throw new ValidationException("homeName", homeName, "validation.home-name-too-short");
        }
        if (homeName.length() > 16) {
            throw new ValidationException("homeName", homeName, "validation.home-name-too-long");
        }
        if (!HOME_NAME_PATTERN.matcher(homeName).matches()) {
            throw new ValidationException("homeName", homeName, "validation.home-name-invalid-chars");
        }
    }

    public static boolean isValidWarpName(String warpName) {
        return warpName != null && warpName.length() >= 3 && warpName.length() <= 32 && WARP_NAME_PATTERN.matcher(warpName).matches();
    }

    public static void validateWarpName(String warpName) throws ValidationException {
        if (warpName == null) {
            throw new ValidationException("warpName", null, "validation.warp-name-invalid");
        }
        if (warpName.length() < 3) {
            throw new ValidationException("warpName", warpName, "validation.warp-name-too-short");
        }
        if (warpName.length() > 32) {
            throw new ValidationException("warpName", warpName, "validation.warp-name-too-long");
        }
        if (!WARP_NAME_PATTERN.matcher(warpName).matches()) {
            throw new ValidationException("warpName", warpName, "validation.warp-name-invalid-chars");
        }
    }

    public static boolean isValidNickname(String nickname) {
        if (nickname == null) {
            return false;
        }
        String stripped = nickname.replaceAll("&[0-9a-fk-or]", "");
        return stripped.length() >= 3 && stripped.length() <= 16 && NICKNAME_PATTERN.matcher(nickname).matches();
    }

    public static void validateNickname(String nickname) throws ValidationException {
        if (nickname == null) {
            throw new ValidationException("nickname", null, "validation.nickname-invalid");
        }
        String stripped = nickname.replaceAll("&[0-9a-fk-or]", "");
        if (stripped.length() < 3) {
            throw new ValidationException("nickname", nickname, "validation.nickname-too-short");
        }
        if (stripped.length() > 16) {
            throw new ValidationException("nickname", nickname, "validation.nickname-too-long");
        }
        if (!NICKNAME_PATTERN.matcher(nickname).matches()) {
            throw new ValidationException("nickname", nickname, "validation.nickname-invalid");
        }
    }

    public static boolean isValidLocation(Location location) {
        if (location == null) {
            return false;
        }
        if (location.getWorld() == null) {
            return false;
        }
        if (Double.isNaN(location.getX())) {
            return false;
        }
        if (Double.isNaN(location.getY())) {
            return false;
        }
        if (Double.isNaN(location.getZ())) {
            return false;
        }
        if (Double.isInfinite(location.getX())) {
            return false;
        }
        if (Double.isInfinite(location.getY())) {
            return false;
        }
        return !Double.isInfinite(location.getZ());
    }

    public static void validateLocation(Location location) throws ValidationException {
        if (location == null) {
            throw new ValidationException("location", null, "validation.location-invalid");
        }
        if (location.getWorld() == null) {
            throw new ValidationException("location", location, "validation.location-invalid");
        }
        if (Double.isNaN(location.getX()) || Double.isNaN(location.getY()) || Double.isNaN(location.getZ())) {
            throw new ValidationException("location", location, "validation.location-invalid");
        }
        if (Double.isInfinite(location.getX()) || Double.isInfinite(location.getY()) || Double.isInfinite(location.getZ())) {
            throw new ValidationException("location", location, "validation.location-invalid");
        }
    }

    public static boolean isSafeLocation(Location location) {
        if (!Validator.isValidLocation(location)) {
            return false;
        }
        if (location.getY() < 0.0 || location.getY() > 256.0) {
            return false;
        }
        Location below = location.clone().subtract(0.0, 1.0, 0.0);
        Material blockType = below.getBlock().getType();
        return blockType != Material.LAVA && blockType != Material.FIRE && !blockType.name().contains("LAVA") && !blockType.name().contains("FIRE");
    }

    public static boolean isValidPlayer(Player player) {
        return player != null && player.isOnline();
    }

    public static void validatePlayer(Player player) throws ValidationException {
        if (player == null) {
            throw new ValidationException("player", null, "Player cannot be null");
        }
        if (!player.isOnline()) {
            throw new ValidationException("player", player.getName(), "general.player-offline");
        }
    }

    public static boolean isInRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static void validateRange(String fieldName, int value, int min, int max) throws ValidationException {
        if (value < min) {
            throw new ValidationException(fieldName, value, String.format("Value too low (min: %d)", min));
        }
        if (value > max) {
            throw new ValidationException(fieldName, value, String.format("Value too high (max: %d)", max));
        }
    }

    public static boolean isPositive(int value) {
        return value > 0;
    }

    public static void validatePositive(String fieldName, int value) throws ValidationException {
        if (value <= 0) {
            throw new ValidationException(fieldName, value, "Value must be positive");
        }
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public static void validateNotEmpty(String fieldName, String str) throws ValidationException {
        if (str == null) {
            throw new ValidationException(fieldName, null, "String cannot be null");
        }
        if (str.trim().isEmpty()) {
            throw new ValidationException(fieldName, str, "String cannot be empty");
        }
    }

    public static boolean isValidLength(String str, int minLength, int maxLength) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        return length >= minLength && length <= maxLength;
    }

    public static void validateLength(String fieldName, String str, int minLength, int maxLength) throws ValidationException {
        if (str == null) {
            throw new ValidationException(fieldName, null, "String cannot be null");
        }
        int length = str.length();
        if (length < minLength) {
            throw new ValidationException(fieldName, str, String.format("String too short (min: %d)", minLength));
        }
        if (length > maxLength) {
            throw new ValidationException(fieldName, str, String.format("String too long (max: %d)", maxLength));
        }
    }
}

