/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.utils;

import fr.skynex.mycommands.MyCommands;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginLogger {
    private final MyCommands plugin;
    private final Logger logger;
    private final DateTimeFormatter timeFormatter;
    private final Path logFile;
    private boolean debugEnabled;
    private boolean fileLoggingEnabled;
    private LogLevel minimumLevel;

    public PluginLogger(MyCommands plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        this.logFile = Paths.get(plugin.getDataFolder().getPath(), "mycommands.log");
        this.loadConfig();
        this.initializeLogFile();
    }

    private void loadConfig() {
        this.debugEnabled = this.plugin.getConfig().getBoolean("logging.debug-enabled", false);
        this.fileLoggingEnabled = this.plugin.getConfig().getBoolean("logging.file-enabled", false);
        String levelStr = this.plugin.getConfig().getString("logging.minimum-level", "INFO");
        this.minimumLevel = LogLevel.valueOf(levelStr.toUpperCase());
        this.logger.info(String.format("Logger: Debug=%s, File=%s, Level=%s", new Object[]{this.debugEnabled, this.fileLoggingEnabled, this.minimumLevel}));
    }

    private void initializeLogFile() {
        if (!this.fileLoggingEnabled) {
            return;
        }
        try {
            if (!Files.exists(this.logFile, new LinkOption[0])) {
                Files.createFile(this.logFile, new FileAttribute[0]);
            }
            String header = String.format("\n========== MyCommands Started: %s ==========\n", LocalDateTime.now().format(this.timeFormatter));
            Files.write(this.logFile, header.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            this.logger.warning("Impossible de cr\u00e9er le fichier de log: " + e.getMessage());
        }
    }

    public void info(String message) {
        this.log(LogLevel.INFO, message);
    }

    public void info(String message, Object ... args) {
        this.log(LogLevel.INFO, String.format(message, args));
    }

    public void warn(String message) {
        this.log(LogLevel.WARNING, message);
    }

    public void warn(String message, Object ... args) {
        this.log(LogLevel.WARNING, String.format(message, args));
    }

    public void error(String message) {
        this.log(LogLevel.ERROR, message);
    }

    public void error(String message, Object ... args) {
        this.log(LogLevel.ERROR, String.format(message, args));
    }

    public void error(String message, Throwable throwable) {
        this.log(LogLevel.ERROR, message + ": " + throwable.getMessage());
        if (this.debugEnabled) {
            if (this.fileLoggingEnabled) {
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    throwable.printStackTrace(pw);
                    this.logToFile(LogLevel.ERROR, sw.toString());
                }
                catch (IOException e) {
                    this.logger.warning("Erreur lors de l'\u00e9criture de la stack trace");
                }
            }
            throwable.printStackTrace();
        }
    }

    public void debug(String message) {
        if (this.debugEnabled) {
            this.log(LogLevel.DEBUG, message);
        }
    }

    public void debug(String message, Object ... args) {
        if (this.debugEnabled) {
            this.log(LogLevel.DEBUG, String.format(message, args));
        }
    }

    public void success(String message) {
        this.log(LogLevel.SUCCESS, message);
    }

    public void success(String message, Object ... args) {
        this.log(LogLevel.SUCCESS, String.format(message, args));
    }

    private void log(LogLevel level, String message) {
        if (level.getPriority() < this.minimumLevel.getPriority()) {
            return;
        }
        String formattedMessage = String.format("[%s] %s", level.getPrefix(), message);
        Level javaLevel = level.getJavaLevel();
        this.logger.log(javaLevel, formattedMessage);
        if (this.fileLoggingEnabled) {
            this.logToFile(level, message);
        }
    }

    private void logToFile(LogLevel level, String message) {
        try {
            String timestamp = LocalDateTime.now().format(this.timeFormatter);
            String logLine = String.format("[%s] [%s] %s\n", timestamp, level.name(), message);
            Files.write(this.logFile, logLine.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            this.logger.warning("Erreur lors de l'\u00e9criture dans le fichier de log: " + e.getMessage());
        }
    }

    public void logTeleport(String playerName, String from, String to, String type) {
        this.debug("Teleport [%s]: %s -> %s (type: %s)", playerName, from, to, type);
    }

    public void logEconomyTransaction(String playerName, String action, double amount, boolean success) {
        if (success) {
            this.debug("Economy [%s]: %s (-%s)", playerName, action, amount);
        } else {
            this.debug("Economy [%s]: %s FAILED (insufficient funds)", playerName, action);
        }
    }

    public void logDatabaseOperation(String operation, long duration, int rowsAffected) {
        this.debug("Database: %s completed in %dms (%d rows)", operation, duration, rowsAffected);
    }

    public void logValidationError(String fieldName, Object invalidValue, String reason) {
        this.warn("Validation failed: field=%s, value=%s, reason=%s", fieldName, invalidValue, reason);
    }

    public void reload() {
        this.loadConfig();
    }

    public void shutdown() {
        if (this.fileLoggingEnabled) {
            try {
                String footer = String.format("========== MyCommands Stopped: %s ==========\n\n", LocalDateTime.now().format(this.timeFormatter));
                Files.write(this.logFile, footer.getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                this.logger.warning("Erreur lors de l'\u00e9criture du footer de log");
            }
        }
    }

    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
        this.info("Debug mode: %s", enabled ? "ENABLED" : "DISABLED");
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public static enum LogLevel {
        DEBUG("DEBUG", 0, Level.FINE),
        INFO("INFO", 1, Level.INFO),
        SUCCESS("SUCCESS", 2, Level.INFO),
        WARNING("WARN", 3, Level.WARNING),
        ERROR("ERROR", 4, Level.SEVERE);

        private final String prefix;
        private final int priority;
        private final Level javaLevel;

        private LogLevel(String prefix, int priority, Level javaLevel) {
            this.prefix = prefix;
            this.priority = priority;
            this.javaLevel = javaLevel;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getPriority() {
            return this.priority;
        }

        public Level getJavaLevel() {
            return this.javaLevel;
        }
    }
}

