/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final MyCommands plugin;
    private FileConfiguration messages;
    private File messagesFile;
    private String language;
    private final Map<String, String> messageCache = new HashMap<String, String>();

    public MessageManager(MyCommands plugin) {
        this.plugin = plugin;
        this.language = plugin.getConfig().getString("language", "en");
        this.loadMessages();
    }

    private void loadMessages() {
        String fileName = "messages_" + this.language + ".yml";
        String resourcePath = "languages/" + fileName;
        File languagesFolder = new File(this.plugin.getDataFolder(), "languages");
        if (!languagesFolder.exists()) {
            languagesFolder.mkdirs();
        }
        this.messagesFile = new File(languagesFolder, fileName);
        if (!this.messagesFile.exists()) {
            try {
                this.plugin.saveResource(resourcePath, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defaultStream = this.plugin.getResource(resourcePath);
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
            this.messages.setDefaults((Configuration)defaultConfig);
        }
        this.cacheAllMessages();
    }

    private void cacheAllMessages() {
        this.messageCache.clear();
        for (String key : this.messages.getKeys(true)) {
            if (this.messages.isConfigurationSection(key)) continue;
            this.messageCache.put(key, this.messages.getString(key));
        }
    }

    public String getMessage(String key) {
        String message = this.messageCache.get(key);
        if (message == null) {
            message = this.messages.getString(key, "&cMessage not found: " + key);
            this.messageCache.put(key, message);
        }
        return message;
    }

    public String getMessage(String key, Placeholder ... placeholders) {
        String message = this.getMessage(key);
        for (Placeholder placeholder : placeholders) {
            message = message.replace(placeholder.getKey(), placeholder.getValue());
        }
        return message;
    }

    public void sendMessage(CommandSender sender, String key) {
        String message = this.getMessage(key);
        sender.sendMessage(this.colorize(message));
    }

    public void sendMessage(CommandSender sender, String key, Placeholder ... placeholders) {
        String message = this.getMessage(key, placeholders);
        sender.sendMessage(this.colorize(message));
    }

    public void sendMessage(Iterable<? extends CommandSender> senders, String key) {
        String message = this.colorize(this.getMessage(key));
        for (CommandSender commandSender : senders) {
            commandSender.sendMessage(message);
        }
    }

    public void sendMessage(Iterable<? extends CommandSender> senders, String key, Placeholder ... placeholders) {
        String message = this.colorize(this.getMessage(key, placeholders));
        for (CommandSender commandSender : senders) {
            commandSender.sendMessage(message);
        }
    }

    public void sendConsoleMessage(String key) {
        String message = this.getMessage(key);
        this.plugin.getLogger().info(ChatColor.stripColor((String)this.colorize(message)));
    }

    public void sendConsoleMessage(String key, Placeholder ... placeholders) {
        String message = this.getMessage(key, placeholders);
        this.plugin.getLogger().info(ChatColor.stripColor((String)this.colorize(message)));
    }

    public void broadcast(String key) {
        String message = this.colorize(this.getMessage(key));
        this.plugin.getServer().broadcastMessage(message);
    }

    public void broadcast(String key, Placeholder ... placeholders) {
        String message = this.colorize(this.getMessage(key, placeholders));
        this.plugin.getServer().broadcastMessage(message);
    }

    public void broadcast(String key, String permission) {
        String message = this.colorize(this.getMessage(key));
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
        }
    }

    public void broadcast(String key, String permission, Placeholder ... placeholders) {
        String message = this.colorize(this.getMessage(key, placeholders));
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(message);
        }
    }

    public String colorize(String text) {
        if (text == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public String stripColor(String text) {
        if (text == null) {
            return "";
        }
        return ChatColor.stripColor((String)this.colorize(text));
    }

    public Placeholder placeholder(String key, String value) {
        return new Placeholder(key, value);
    }

    public Placeholder placeholder(String key, int value) {
        return new Placeholder(key, String.valueOf(value));
    }

    public Placeholder placeholder(String key, long value) {
        return new Placeholder(key, String.valueOf(value));
    }

    public Placeholder placeholder(String key, double value) {
        return new Placeholder(key, String.valueOf(value));
    }

    public boolean hasMessage(String key) {
        return this.messageCache.containsKey(key) || this.messages.contains(key);
    }

    public String getRawMessage(String key) {
        return this.messageCache.getOrDefault(key, this.messages.getString(key, "Message not found: " + key));
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        this.plugin.getConfig().set("language", (Object)language);
        this.plugin.saveConfig();
        this.loadMessages();
    }

    public void reload() {
        this.language = this.plugin.getConfig().getString("language", "en");
        this.loadMessages();
        this.plugin.getLogger().info("Messages reloaded: " + this.language.toUpperCase());
    }

    public void save() {
        try {
            this.messages.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save messages: " + e.getMessage());
        }
    }

    public FileConfiguration getMessagesConfig() {
        return this.messages;
    }

    public MessageBuilder builder() {
        return new MessageBuilder(this);
    }

    public String formatList(Iterable<String> items) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String item : items) {
            if (count > 0) {
                builder.append(this.getMessage("general.list-separator"));
            }
            builder.append(item);
            ++count;
        }
        return builder.toString();
    }

    public String formatTime(long seconds) {
        if (seconds < 60L) {
            return this.getMessage("time.seconds", this.placeholder("seconds", (int)seconds));
        }
        if (seconds < 3600L) {
            int minutes = (int)(seconds / 60L);
            return this.getMessage("time.minutes", this.placeholder("minutes", minutes));
        }
        if (seconds < 86400L) {
            int hours = (int)(seconds / 3600L);
            return this.getMessage("time.hours", this.placeholder("hours", hours));
        }
        int days = (int)(seconds / 86400L);
        return this.getMessage("time.days", this.placeholder("days", days));
    }

    public String formatMoney(double amount) {
        String symbol = this.plugin.getConfig().getString("economy.currency-symbol", "$");
        return symbol + String.format("%.2f", amount);
    }

    public static class Placeholder {
        private final String key;
        private final String value;

        public Placeholder(String key, String value) {
            this.key = "{" + key + "}";
            this.value = value != null ? value : "";
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class MessageBuilder {
        private final MessageManager manager;
        private String key;
        private final Map<String, String> placeholders = new HashMap<String, String>();

        public MessageBuilder(MessageManager manager) {
            this.manager = manager;
        }

        public MessageBuilder key(String key) {
            this.key = key;
            return this;
        }

        public MessageBuilder placeholder(String key, String value) {
            this.placeholders.put(key, value);
            return this;
        }

        public MessageBuilder placeholder(String key, int value) {
            this.placeholders.put(key, String.valueOf(value));
            return this;
        }

        public MessageBuilder placeholder(String key, double value) {
            this.placeholders.put(key, String.valueOf(value));
            return this;
        }

        public String build() {
            String message = this.manager.getMessage(this.key);
            for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            return message;
        }

        public void send(CommandSender sender) {
            sender.sendMessage(this.manager.colorize(this.build()));
        }

        public void broadcast() {
            this.manager.plugin.getServer().broadcastMessage(this.manager.colorize(this.build()));
        }
    }
}

