/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EffectsManager {
    private final MyCommands plugin;
    private boolean enabled;
    private boolean teleportEffectsEnabled;
    private boolean creationEffectsEnabled;

    public EffectsManager(MyCommands plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("effects.enabled", true);
        this.teleportEffectsEnabled = this.plugin.getConfig().getBoolean("effects.particles.teleport.enabled", true);
        this.creationEffectsEnabled = this.plugin.getConfig().getBoolean("effects.particles.creation.enabled", true);
    }

    public void reload() {
        this.loadConfig();
    }

    public void playPreviewEffect(Location location) {
        if (!this.enabled || !this.teleportEffectsEnabled) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("teleport.preview.show-particles", true)) {
            return;
        }
        location.getWorld().spawnParticle(Particle.CLOUD, location.clone().add(0.0, 1.0, 0.0), 5, 0.3, 0.3, 0.3, 0.0);
    }

    public void playDepartureEffect(final Location location) {
        if (!this.enabled || !this.teleportEffectsEnabled) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("effects.particles.teleport.departure", true)) {
            return;
        }
        new BukkitRunnable(this){
            double angle = 0.0;
            int ticks = 0;
            final /* synthetic */ EffectsManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= 15) {
                    this.cancel();
                    return;
                }
                double radius = 0.5;
                double x = Math.cos(this.angle) * radius;
                double z = Math.sin(this.angle) * radius;
                double y = (double)this.ticks * 0.15;
                location.getWorld().spawnParticle(Particle.PORTAL, location.clone().add(x, y, z), 3, 0.1, 0.1, 0.1, 0.0);
                this.angle += 0.7853981633974483;
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void playArrivalEffect(Location location) {
        if (!this.enabled || !this.teleportEffectsEnabled) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("effects.particles.teleport.arrival", true)) {
            return;
        }
        location.getWorld().spawnParticle(Particle.FLAME, location.clone().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.05);
        location.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, location.clone().add(0.0, 0.5, 0.0), 20, 0.5, 0.3, 0.5, 0.0);
    }

    public void playCountdownEffect(final Player player, final int seconds) {
        if (!this.enabled || !this.teleportEffectsEnabled) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("effects.particles.teleport.countdown", true)) {
            return;
        }
        new BukkitRunnable(this){
            int remaining;
            final /* synthetic */ EffectsManager this$0;
            {
                this.this$0 = this$0;
                this.remaining = seconds;
            }

            public void run() {
                if (this.remaining <= 0 || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                Location loc = player.getLocation();
                double radius = 1.0 + 0.3 * Math.sin((double)System.currentTimeMillis() / 200.0);
                for (int i = 0; i < 20; ++i) {
                    double angle = Math.PI * 2 * (double)i / 20.0;
                    double x = Math.cos(angle) * radius;
                    double z = Math.sin(angle) * radius;
                    loc.getWorld().spawnParticle(Particle.WITCH, loc.clone().add(x, 0.1, z), 1, 0.0, 0.0, 0.0, 0.0);
                }
                --this.remaining;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void playHomeCreatedEffect(final Location location) {
        if (!this.enabled || !this.creationEffectsEnabled) {
            return;
        }
        new BukkitRunnable(this){
            double angle = 0.0;
            int ticks = 0;
            final /* synthetic */ EffectsManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= 20) {
                    this.cancel();
                    return;
                }
                double radius = 0.5;
                double x = Math.cos(this.angle) * radius;
                double z = Math.sin(this.angle) * radius;
                double y = (double)this.ticks * 0.1;
                location.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, location.clone().add(x, y, z), 2, 0.0, 0.0, 0.0, 0.0);
                this.angle += 1.0471975511965976;
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void playHomeDeletedEffect(Location location) {
        if (!this.enabled || !this.creationEffectsEnabled) {
            return;
        }
        try {
            Particle.DustOptions dust = new Particle.DustOptions(Color.RED, 1.0f);
            location.getWorld().spawnParticle(Particle.CRIT, location.clone().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.0, (Object)dust);
        }
        catch (Exception e) {
            location.getWorld().spawnParticle(Particle.SMOKE, location.clone().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.05);
        }
    }

    public void playSuccessEffect(Location location) {
        if (!this.enabled) {
            return;
        }
        location.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, location.clone().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.0);
    }

    public void playErrorEffect(Location location) {
        if (!this.enabled) {
            return;
        }
        location.getWorld().spawnParticle(Particle.SMOKE, location.clone().add(0.0, 1.0, 0.0), 10, 0.3, 0.3, 0.3, 0.05);
    }

    public void playCircleEffect(Location location, Particle particle, double radius, int points) {
        if (!this.enabled) {
            return;
        }
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            location.getWorld().spawnParticle(particle, location.clone().add(x, 0.1, z), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void playPillarEffect(Location location, Particle particle, double height, int density) {
        if (!this.enabled) {
            return;
        }
        for (int i = 0; i < density; ++i) {
            double y = height * (double)i / (double)density;
            location.getWorld().spawnParticle(particle, location.clone().add(0.0, y, 0.0), 3, 0.1, 0.0, 0.1, 0.0);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

