/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.integrations.VaultIntegration;
import fr.skynex.mycommands.managers.MessageManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EconomyManager {
    private final MyCommands plugin;
    private final MessageManager msg;
    private final VaultIntegration vault;
    private final Map<String, Double> costs = new HashMap<String, Double>();
    private final Map<String, Double> discounts = new HashMap<String, Double>();
    private boolean enabled = false;

    public EconomyManager(MyCommands plugin, VaultIntegration vault) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        this.vault = vault;
        if (vault != null && vault.setupEconomy()) {
            this.enabled = plugin.getConfig().getBoolean("economy.enabled", true);
            this.loadCosts();
            this.loadDiscounts();
            plugin.getLogger().info("EconomyManager initialized with Vault");
        } else {
            plugin.getLogger().warning("EconomyManager disabled (Vault not found)");
        }
    }

    private void loadCosts() {
        this.costs.clear();
        this.costs.put("home", this.plugin.getConfig().getDouble("economy.costs.home-teleport", 0.0));
        this.costs.put("sethome", this.plugin.getConfig().getDouble("economy.costs.home-set", 0.0));
        this.costs.put("delhome", this.plugin.getConfig().getDouble("economy.costs.home-delete", 0.0));
        this.costs.put("warp", this.plugin.getConfig().getDouble("economy.costs.warp", 0.0));
        this.costs.put("spawn", this.plugin.getConfig().getDouble("economy.costs.spawn", 0.0));
        this.costs.put("back", this.plugin.getConfig().getDouble("economy.costs.back", 0.0));
        this.costs.put("tpa", this.plugin.getConfig().getDouble("economy.costs.tpa-request", 0.0));
        this.costs.put("nick-change", this.plugin.getConfig().getDouble("economy.costs.nick-change", 0.0));
        this.plugin.getLogger().info("Loaded " + this.costs.size() + " economy costs");
    }

    private void loadDiscounts() {
        this.discounts.clear();
        this.discounts.put("mycommands.economy.discount.vip", 0.1);
        this.discounts.put("mycommands.economy.discount.mvp", 0.25);
        this.discounts.put("mycommands.economy.discount.admin", 0.5);
        this.plugin.getLogger().info("Loaded " + this.discounts.size() + " VIP discounts");
    }

    public double getCost(String action) {
        return this.costs.getOrDefault(action, 0.0);
    }

    public double getCostWithDiscount(Player player, String action) {
        double baseCost = this.getCost(action);
        if (baseCost <= 0.0) {
            return 0.0;
        }
        double discount = this.getPlayerDiscount(player);
        return baseCost * (1.0 - discount);
    }

    public double getPlayerDiscount(Player player) {
        if (player.hasPermission("mycommands.economy.discount.admin")) {
            return this.discounts.get("mycommands.economy.discount.admin");
        }
        if (player.hasPermission("mycommands.economy.discount.mvp")) {
            return this.discounts.get("mycommands.economy.discount.mvp");
        }
        if (player.hasPermission("mycommands.economy.discount.vip")) {
            return this.discounts.get("mycommands.economy.discount.vip");
        }
        return 0.0;
    }

    public boolean has(Player player, double amount) {
        if (!this.enabled || this.vault == null || this.vault.getEconomy() == null) {
            return true;
        }
        return this.vault.getEconomy().has((OfflinePlayer)player, amount);
    }

    public boolean withdraw(Player player, double amount) {
        if (!this.enabled || this.vault == null || this.vault.getEconomy() == null) {
            return true;
        }
        return this.vault.getEconomy().withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess();
    }

    public boolean deposit(Player player, double amount) {
        if (!this.enabled || this.vault == null || this.vault.getEconomy() == null) {
            return true;
        }
        return this.vault.getEconomy().depositPlayer((OfflinePlayer)player, amount).transactionSuccess();
    }

    public double getBalance(Player player) {
        if (!this.enabled || this.vault == null || this.vault.getEconomy() == null) {
            return 0.0;
        }
        return this.vault.getEconomy().getBalance((OfflinePlayer)player);
    }

    public boolean canAfford(Player player, String action) {
        if (!this.enabled || this.vault == null) {
            return true;
        }
        double cost = this.getCostWithDiscount(player, action);
        if (cost <= 0.0) {
            return true;
        }
        return this.has(player, cost);
    }

    public boolean charge(Player player, String action) {
        if (!this.enabled || this.vault == null) {
            return true;
        }
        double cost = this.getCostWithDiscount(player, action);
        if (cost <= 0.0) {
            return true;
        }
        if (!this.has(player, cost)) {
            this.msg.sendMessage((CommandSender)player, "economy.insufficient-funds", this.msg.placeholder("cost", this.msg.formatMoney(cost)), this.msg.placeholder("balance", this.msg.formatMoney(this.getBalance(player))));
            return false;
        }
        if (!this.withdraw(player, cost)) {
            return false;
        }
        if (this.plugin.getConfig().getBoolean("economy.show-charge-message", true)) {
            this.msg.sendMessage((CommandSender)player, "economy.charged", this.msg.placeholder("amount", this.msg.formatMoney(cost)));
        }
        return true;
    }

    public void refund(Player player, String action) {
        if (!this.enabled || this.vault == null) {
            return;
        }
        double cost = this.getCostWithDiscount(player, action);
        if (cost <= 0.0) {
            return;
        }
        this.deposit(player, cost);
        if (this.plugin.getConfig().getBoolean("economy.show-refund-message", true)) {
            this.msg.sendMessage((CommandSender)player, "economy.refunded", this.msg.placeholder("amount", this.msg.formatMoney(cost)));
        }
    }

    public void pay(Player player, double amount) {
        if (!this.enabled || this.vault == null) {
            return;
        }
        this.deposit(player, amount);
    }

    public void take(Player player, double amount) {
        if (!this.enabled || this.vault == null) {
            return;
        }
        this.withdraw(player, amount);
    }

    public void setBalance(Player player, double amount) {
        if (!this.enabled || this.vault == null) {
            return;
        }
        double current = this.getBalance(player);
        double difference = amount - current;
        if (difference > 0.0) {
            this.deposit(player, difference);
        } else if (difference < 0.0) {
            this.withdraw(player, Math.abs(difference));
        }
    }

    public String getFormattedBalance(Player player) {
        if (!this.enabled || this.vault == null) {
            return "N/A";
        }
        return this.msg.formatMoney(this.getBalance(player));
    }

    public String getCurrencySymbol() {
        if (!this.enabled || this.vault == null || this.vault.getEconomy() == null) {
            return this.plugin.getConfig().getString("economy.currency-symbol", "$");
        }
        return this.vault.getEconomy().currencyNameSingular();
    }

    public String getCurrencyName(boolean plural) {
        if (!this.enabled || this.vault == null || this.vault.getEconomy() == null) {
            return plural ? "dollars" : "dollar";
        }
        return plural ? this.vault.getEconomy().currencyNamePlural() : this.vault.getEconomy().currencyNameSingular();
    }

    public boolean isEnabled() {
        return this.enabled && this.vault != null && this.vault.getEconomy() != null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.plugin.getConfig().set("economy.enabled", (Object)enabled);
        this.plugin.saveConfig();
    }

    public void reload() {
        this.enabled = this.plugin.getConfig().getBoolean("economy.enabled", true);
        this.loadCosts();
        this.loadDiscounts();
        this.plugin.getLogger().info("EconomyManager reloaded");
    }

    public VaultIntegration getVault() {
        return this.vault;
    }

    public int getPaidActionsCount() {
        int count = 0;
        for (double cost : this.costs.values()) {
            if (!(cost > 0.0)) continue;
            ++count;
        }
        return count;
    }

    public double getTotalCosts() {
        return this.costs.values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public double getAverageCost() {
        if (this.costs.isEmpty()) {
            return 0.0;
        }
        return this.getTotalCosts() / (double)this.costs.size();
    }

    public void printStats() {
        this.plugin.getLogger().info("=== EconomyManager Stats ===");
        this.plugin.getLogger().info("Enabled: " + this.enabled);
        this.plugin.getLogger().info("Vault: " + (this.vault != null ? "Connected" : "Not found"));
        this.plugin.getLogger().info("Costs loaded: " + this.costs.size());
        this.plugin.getLogger().info("Discounts loaded: " + this.discounts.size());
        this.plugin.getLogger().info("Paid actions: " + this.getPaidActionsCount());
        this.plugin.getLogger().info("Total costs: " + this.msg.formatMoney(this.getTotalCosts()));
    }

    public void listCosts() {
        this.plugin.getLogger().info("=== Economy Costs ===");
        for (Map.Entry<String, Double> entry : this.costs.entrySet()) {
            this.plugin.getLogger().info(entry.getKey() + ": " + this.msg.formatMoney(entry.getValue()));
        }
    }

    public void listDiscounts() {
        this.plugin.getLogger().info("=== VIP Discounts ===");
        for (Map.Entry<String, Double> entry : this.discounts.entrySet()) {
            this.plugin.getLogger().info(entry.getKey() + ": " + entry.getValue() * 100.0 + "%");
        }
    }
}

