/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.MessageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ConfirmationManager {
    private final MyCommands plugin;
    private final MessageManager msg;
    private final Map<UUID, ConfirmationRequest> pendingConfirmations = new HashMap<UUID, ConfirmationRequest>();
    private BukkitTask cleanupTask;

    public ConfirmationManager(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        this.startCleanupTask();
    }

    private void startCleanupTask() {
        this.cleanupTask = new BukkitRunnable(){

            public void run() {
                ConfirmationManager.this.cleanExpiredConfirmations();
            }
        }.runTaskTimer((Plugin)this.plugin, 200L, 200L);
    }

    private void cleanExpiredConfirmations() {
        long now = System.currentTimeMillis();
        this.pendingConfirmations.entrySet().removeIf(entry -> {
            if (((ConfirmationRequest)entry.getValue()).isExpired(now)) {
                Player player = this.plugin.getServer().getPlayer((UUID)entry.getKey());
                if (player != null && player.isOnline()) {
                    this.msg.sendMessage((CommandSender)player, "confirmation.expired");
                }
                return true;
            }
            return false;
        });
    }

    public void requestHomeDelete(Player player, String homeName, int teleportCount, String createdDate, Runnable onConfirm) {
        String message = this.msg.getMessage("confirmation.home-delete", this.msg.placeholder("home", homeName), this.msg.placeholder("date", createdDate), this.msg.placeholder("count", String.valueOf(teleportCount)));
        this.sendConfirmationRequest(player, message, onConfirm, "home");
    }

    public void requestWarpDelete(Player player, String warpName, Runnable onConfirm) {
        String message = this.msg.getMessage("confirmation.warp-delete", this.msg.placeholder("warp", warpName));
        this.sendConfirmationRequest(player, message, onConfirm, "warp");
    }

    public void requestConfirmation(Player player, String message, Runnable onConfirm) {
        this.sendConfirmationRequest(player, message, onConfirm, "generic");
    }

    private void sendConfirmationRequest(Player player, String message, Runnable onConfirm, String type) {
        int timeout = this.plugin.getConfig().getInt("confirmations.timeout", 30);
        ConfirmationRequest request = new ConfirmationRequest(player.getUniqueId(), onConfirm, timeout, type);
        this.pendingConfirmations.put(player.getUniqueId(), request);
        player.sendMessage(message);
        this.sendConfirmationButtons(player, timeout);
        player.sendMessage(this.msg.colorize(" &7Expiration dans &e" + timeout + "s\n&6&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
    }

    private void sendConfirmationButtons(Player player, int timeout) {
        TextComponent confirmButton = new TextComponent(this.msg.colorize(" &a&l[\u2713 CONFIRMER]"));
        confirmButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/confirm"));
        confirmButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.msg.colorize("&aCliquer pour confirmer l'action"))}));
        TextComponent cancelButton = new TextComponent(this.msg.colorize(" &c&l[\u2717 ANNULER]"));
        cancelButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cancel"));
        cancelButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.msg.colorize("&cCliquer pour annuler"))}));
        player.spigot().sendMessage(new BaseComponent[]{confirmButton, cancelButton});
    }

    public boolean confirm(Player player) {
        ConfirmationRequest request = this.pendingConfirmations.remove(player.getUniqueId());
        if (request == null) {
            this.msg.sendMessage((CommandSender)player, "confirmation.no-pending");
            return true;
        }
        if (request.isExpired(System.currentTimeMillis())) {
            this.msg.sendMessage((CommandSender)player, "confirmation.expired");
            return true;
        }
        try {
            request.getAction().run();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error executing confirmation action: " + e.getMessage());
            e.printStackTrace();
            this.msg.sendMessage((CommandSender)player, "general.error");
        }
        return true;
    }

    public boolean cancel(Player player) {
        ConfirmationRequest request = this.pendingConfirmations.remove(player.getUniqueId());
        if (request == null) {
            this.msg.sendMessage((CommandSender)player, "confirmation.no-pending");
            return true;
        }
        this.msg.sendMessage((CommandSender)player, "confirmation.cancelled");
        return true;
    }

    public boolean hasPendingConfirmation(Player player) {
        return this.pendingConfirmations.containsKey(player.getUniqueId());
    }

    public void cancelAll(UUID uuid) {
        this.pendingConfirmations.remove(uuid);
    }

    public void shutdown() {
        if (this.cleanupTask != null && !this.cleanupTask.isCancelled()) {
            this.cleanupTask.cancel();
        }
        for (UUID uuid : this.pendingConfirmations.keySet()) {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player == null || !player.isOnline()) continue;
            this.msg.sendMessage((CommandSender)player, "confirmation.cancelled");
        }
        this.pendingConfirmations.clear();
        this.plugin.getLogger().info("ConfirmationManager shutdown complete");
    }

    public void reload() {
        this.cleanExpiredConfirmations();
    }

    private static class ConfirmationRequest {
        private final Runnable action;
        private final long expiresAt;

        public ConfirmationRequest(UUID playerId, Runnable action, int timeoutSeconds, String type) {
            this.action = action;
            this.expiresAt = System.currentTimeMillis() + (long)timeoutSeconds * 1000L;
        }

        public Runnable getAction() {
            return this.action;
        }

        public boolean isExpired(long currentTime) {
            return currentTime >= this.expiresAt;
        }
    }
}

