/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.listeners;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.AFKManager;
import fr.skynex.mycommands.managers.DataManager;
import fr.skynex.mycommands.managers.MessageManager;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerListener
implements Listener {
    private final MyCommands plugin;
    private final DataManager dataManager;
    private final MessageManager msg;
    private final AFKManager afkManager;

    public PlayerListener(MyCommands plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
        this.msg = plugin.getMessageManager();
        this.afkManager = plugin.getAFKManager();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveForAFK(PlayerMoveEvent event) {
        if (this.afkManager == null) {
            return;
        }
        if (this.hasMovedSignificantly(event)) {
            this.afkManager.updateActivity(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerChatForAFK(AsyncPlayerChatEvent event) {
        if (this.afkManager == null) {
            return;
        }
        this.afkManager.updateActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerCommandForAFK(PlayerCommandPreprocessEvent event) {
        if (this.afkManager == null) {
            return;
        }
        String command = event.getMessage().toLowerCase().split(" ")[0];
        if (!command.equals("/afk")) {
            this.afkManager.updateActivity(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.afkManager == null) {
            return;
        }
        this.afkManager.updateActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.afkManager == null) {
            return;
        }
        if (event.getWhoClicked() instanceof Player) {
            this.afkManager.updateActivity((Player)event.getWhoClicked());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (this.afkManager == null) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            this.afkManager.updateActivity((Player)event.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("mycommands.freeze.bypass")) {
            return;
        }
        if (this.dataManager.isFrozen(player.getUniqueId()) && this.hasMovedSignificantly(event)) {
            event.setCancelled(true);
            this.msg.sendMessage((CommandSender)player, "freeze.cannot-move");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("mycommands.freeze.bypass")) {
            return;
        }
        if (this.dataManager.isFrozen(player.getUniqueId())) {
            event.setCancelled(true);
            this.msg.sendMessage((CommandSender)player, "freeze.cannot-chat");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("mycommands.freeze.bypass")) {
            return;
        }
        if (this.dataManager.isFrozen(player.getUniqueId())) {
            String command = event.getMessage().toLowerCase().split(" ")[0];
            if (this.isAllowedWhenFrozen(command)) {
                return;
            }
            event.setCancelled(true);
            this.msg.sendMessage((CommandSender)player, "freeze.cannot-command");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (this.shouldSaveLastLocation(event)) {
            this.dataManager.setLastLocation(player.getUniqueId(), event.getFrom());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (this.plugin.getConfig().getBoolean("back.save-on-death", true)) {
            this.dataManager.setLastLocation(player.getUniqueId(), player.getLocation());
        }
    }

    private boolean hasMovedSignificantly(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return false;
        }
        return from.getX() != to.getX() || from.getY() != to.getY() || from.getZ() != to.getZ();
    }

    private boolean isAllowedWhenFrozen(String command) {
        return command.equalsIgnoreCase("/helpop") || command.equalsIgnoreCase("/help") || command.equalsIgnoreCase("/rules");
    }

    private boolean shouldSaveLastLocation(PlayerTeleportEvent event) {
        return event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND || event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN;
    }
}

