/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class StaticTeleportItem {
    private final String id;
    private final boolean enabled;
    private final int slot;
    private final Material material;
    private final String skullTexture;
    private final String name;
    private final List<String> lore;
    private final Location location;
    private final String permission;

    public StaticTeleportItem(String id, ConfigurationSection section) {
        Material tempMaterial;
        this.id = id;
        this.enabled = section.getBoolean("enabled", true);
        this.slot = section.getInt("slot", 0);
        String materialStr = section.getString("material", "STONE");
        try {
            tempMaterial = Material.valueOf((String)materialStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            tempMaterial = Material.STONE;
        }
        this.material = tempMaterial;
        this.skullTexture = section.getString("skull-texture", null);
        this.name = section.getString("name", "&f" + id);
        this.lore = section.getStringList("lore");
        String worldName = section.getString("world");
        if (worldName != null && Bukkit.getWorld((String)worldName) != null) {
            double x = section.getDouble("x", 0.0);
            double y = section.getDouble("y", 64.0);
            double z = section.getDouble("z", 0.0);
            float yaw = (float)section.getDouble("yaw", 0.0);
            float pitch = (float)section.getDouble("pitch", 0.0);
            this.location = new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
        } else {
            this.location = null;
        }
        this.permission = section.getString("permission", null);
    }

    public ItemStack createItem() {
        ItemStack item = this.material == Material.PLAYER_HEAD && this.skullTexture != null && !this.skullTexture.isEmpty() ? this.createCustomSkull() : new ItemStack(this.material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.colorize(this.name));
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : this.lore) {
                coloredLore.add(this.colorize(line));
            }
            meta.setLore(coloredLore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createCustomSkull() {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            try {
                GameProfile profile = new GameProfile(UUID.randomUUID(), null);
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", this.skullTexture));
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(meta, profile);
                skull.setItemMeta((ItemMeta)meta);
            }
            catch (Exception e) {
                return new ItemStack(Material.PLAYER_HEAD);
            }
        }
        return skull;
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getSlot() {
        return this.slot;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasPermission() {
        return this.permission != null && !this.permission.isEmpty();
    }

    public boolean hasValidLocation() {
        return this.location != null && this.location.getWorld() != null;
    }
}

