/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.exceptions.ValidationException;
import fr.skynex.mycommands.managers.SoundManager;
import fr.skynex.mycommands.managers.StatisticsManager;
import fr.skynex.mycommands.utils.MessageFormatter;
import fr.skynex.mycommands.utils.Validator;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpCommand
extends BaseCommand {
    public WarpCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String warpPerm;
        Player player = this.getPlayerWithPermission(sender, "mycommands.warp");
        if (player == null) {
            return true;
        }
        if (!this.hasArg(args, 0)) {
            this.sendUsage(sender, "/warp <nom>");
            this.playError(player);
            return true;
        }
        String warpName = args[0];
        try {
            Validator.validateWarpName(warpName);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            this.playError(player);
            return true;
        }
        if (this.plugin.getConfig().getBoolean("warps.per-warp-permission", false) && !player.hasPermission(warpPerm = "mycommands.warp." + warpName.toLowerCase())) {
            this.msg.sendMessage((CommandSender)player, "general.no-permission");
            this.playError(player);
            return true;
        }
        Location warpLocation = this.dataManager.getWarp(warpName);
        if (warpLocation == null || warpLocation.getWorld() == null) {
            this.msg.sendMessage((CommandSender)player, "teleport.warp.not-found", this.msg.placeholder("warp", warpName));
            this.playError(player);
            return true;
        }
        try {
            Validator.validateLocation(warpLocation);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            this.playError(player);
            if (player.hasPermission("mycommands.admin")) {
                player.sendMessage(this.msg.colorize("&c&l[ADMIN] &7Ce warp est corrompu. Supprimez-le avec : &e/delwarp " + warpName));
            }
            return true;
        }
        if (this.plugin.getConfig().getBoolean("teleport.preview.enabled", true) && this.plugin.getConfig().getBoolean("teleport.preview.show-particles", true)) {
            this.playPreviewEffect(warpLocation);
        }
        this.startTeleportDelay(player, "warp", () -> {
            this.playDepartureEffect(player.getLocation());
            this.playSuccess(player, SoundManager.SoundType.TELEPORT_START);
            player.teleport(warpLocation);
            this.playArrivalEffect(warpLocation);
            this.playSuccess(player, SoundManager.SoundType.TELEPORT_ARRIVE);
            this.msg.sendMessage((CommandSender)player, "teleport.warp.teleported", this.msg.placeholder("warp", warpName));
            if (this.plugin.getConfig().getBoolean("messages.format.action-bar.enabled", true)) {
                String world = warpLocation.getWorld().getName();
                MessageFormatter.sendActionBar(player, this.msg.colorize("&a\u2713 T\u00e9l\u00e9port\u00e9 \u00e0 &e" + warpName + " &7(" + world + ")"));
            }
            if (this.statsManager != null) {
                this.statsManager.incrementTeleports(player, StatisticsManager.TeleportType.WARP);
            }
        });
        int delay = this.plugin.getConfig().getInt("teleport-delay.delay.warp", 3);
        if (delay > 0 && this.plugin.getConfig().getBoolean("effects.particles.teleport.countdown", true)) {
            this.playCountdownEffect(player, delay);
        }
        return true;
    }
}

