/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TimeCommand
extends BaseCommand {
    public TimeCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.time");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/time <day|night|ticks>");
            return true;
        }
        World world = player.getWorld();
        switch (args[0].toLowerCase()) {
            case "day": {
                world.setTime(1000L);
                this.msg.sendMessage(sender, "time.day");
                break;
            }
            case "night": {
                world.setTime(13000L);
                this.msg.sendMessage(sender, "time.night");
                break;
            }
            case "noon": {
                world.setTime(6000L);
                this.msg.sendMessage(sender, "time.noon");
                break;
            }
            case "midnight": {
                world.setTime(18000L);
                this.msg.sendMessage(sender, "time.midnight");
                break;
            }
            default: {
                try {
                    long time = Long.parseLong(args[0]);
                    world.setTime(time);
                    this.msg.sendMessage(sender, "time.set", this.msg.placeholder("ticks", args[0]));
                    break;
                }
                catch (NumberFormatException e) {
                    this.sendUsage(sender, "/time <day|night|noon|midnight|ticks>");
                    return true;
                }
            }
        }
        return true;
    }
}

