/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.StatisticsManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatsCommand
extends BaseCommand {
    public StatsCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player target;
        if (!this.checkPermission(sender, "mycommands.stats")) {
            return true;
        }
        if (!this.plugin.getConfig().getBoolean("statistics.enabled", true)) {
            this.msg.sendMessage(sender, "stats.disabled");
            return true;
        }
        if (args.length >= 1) {
            if (!sender.hasPermission("mycommands.stats.others")) {
                this.msg.sendMessage(sender, "general.no-permission");
                return true;
            }
            target = this.plugin.getServer().getPlayer(args[0]);
            if (target == null) {
                this.msg.sendMessage(sender, "general.player-not-found");
                return true;
            }
        } else {
            target = this.getPlayer(sender);
            if (target == null) {
                return true;
            }
        }
        StatisticsManager.PlayerStats stats = this.statsManager.getStats(target.getUniqueId());
        sender.sendMessage(this.msg.colorize(this.msg.getMessage("stats.header", this.msg.placeholder("player", target.getName()))));
        sender.sendMessage(this.msg.colorize(String.format("&6T\u00e9l\u00e9portations totales: &e%d", stats.getTotalTeleports())));
        sender.sendMessage(this.msg.colorize(String.format("&6  \u251c\u2500 Homes: &e%d", stats.getTeleports(StatisticsManager.TeleportType.HOME))));
        sender.sendMessage(this.msg.colorize(String.format("&6  \u251c\u2500 Warps: &e%d", stats.getTeleports(StatisticsManager.TeleportType.WARP))));
        sender.sendMessage(this.msg.colorize(String.format("&6  \u251c\u2500 Spawn: &e%d", stats.getTeleports(StatisticsManager.TeleportType.SPAWN))));
        sender.sendMessage(this.msg.colorize(String.format("&6  \u251c\u2500 TPA: &e%d", stats.getTeleports(StatisticsManager.TeleportType.TPA))));
        sender.sendMessage(this.msg.colorize(String.format("&6  \u2514\u2500 Back: &e%d", stats.getTeleports(StatisticsManager.TeleportType.BACK))));
        sender.sendMessage(this.msg.colorize(String.format("&6Homes cr\u00e9\u00e9s: &e%d", stats.getHomesCreated())));
        sender.sendMessage(this.msg.colorize(String.format("&6Messages envoy\u00e9s: &e%d", stats.getMessagesSent())));
        sender.sendMessage(this.msg.colorize(this.msg.getMessage("stats.footer")));
        return true;
    }
}

