/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.SoundManager;
import fr.skynex.mycommands.managers.StatisticsManager;
import fr.skynex.mycommands.utils.MessageFormatter;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpawnCommand
extends BaseCommand {
    public SpawnCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.spawn");
        if (player == null) {
            return true;
        }
        Location spawn = this.dataManager.getSpawn(player.getWorld());
        if (spawn == null) {
            this.msg.sendMessage((CommandSender)player, "teleport.spawn.not-set");
            this.playError(player);
            return true;
        }
        if (this.plugin.getConfig().getBoolean("teleport.preview.enabled", true) && this.plugin.getConfig().getBoolean("teleport.preview.show-particles", true)) {
            this.playPreviewEffect(spawn);
        }
        this.startTeleportDelay(player, "spawn", () -> {
            this.playDepartureEffect(player.getLocation());
            this.playSuccess(player, SoundManager.SoundType.TELEPORT_START);
            player.teleport(spawn);
            this.playArrivalEffect(spawn);
            this.playSuccess(player, SoundManager.SoundType.TELEPORT_ARRIVE);
            this.msg.sendMessage((CommandSender)player, "teleport.spawn.teleported");
            if (this.plugin.getConfig().getBoolean("messages.format.action-bar.enabled", true)) {
                MessageFormatter.sendActionBar(player, this.msg.colorize("&a\u2713 T\u00e9l\u00e9port\u00e9 au spawn !"));
            }
            if (this.statsManager != null) {
                this.statsManager.incrementTeleports(player, StatisticsManager.TeleportType.SPAWN);
            }
        });
        int delay = this.plugin.getConfig().getInt("teleport-delay.delay.spawn", 3);
        if (delay > 0 && this.plugin.getConfig().getBoolean("effects.particles.teleport.countdown", true)) {
            this.playCountdownEffect(player, delay);
        }
        return true;
    }
}

