/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullCommand
extends BaseCommand
implements TabCompleter {
    public SkullCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.skull");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/skull <joueur>");
            return true;
        }
        String targetName = args[0];
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            Player onlinePlayer = this.plugin.getServer().getPlayer(targetName);
            if (onlinePlayer != null) {
                meta.setOwningPlayer((OfflinePlayer)onlinePlayer);
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
                meta.setOwningPlayer(offlinePlayer);
            }
            meta.setDisplayName(this.msg.colorize("&6T\u00eate de " + targetName));
            skull.setItemMeta((ItemMeta)meta);
        }
        player.getInventory().addItem(new ItemStack[]{skull});
        this.msg.sendMessage((CommandSender)player, "commands.skull.success", this.msg.placeholder("player", targetName));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

