/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.exceptions.ValidationException;
import fr.skynex.mycommands.managers.EffectsManager;
import fr.skynex.mycommands.managers.SoundManager;
import fr.skynex.mycommands.utils.MessageFormatter;
import fr.skynex.mycommands.utils.Validator;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetHomeCommand
extends BaseCommand {
    private final EffectsManager effectsManager;
    private final SoundManager soundManager;

    public SetHomeCommand(MyCommands plugin) {
        super(plugin);
        this.effectsManager = plugin.getEffectsManager();
        this.soundManager = plugin.getSoundManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean isUpdate;
        Player player = this.getPlayerWithPermission(sender, "mycommands.sethome");
        if (player == null) {
            return true;
        }
        String homeName = this.getArgOrDefault(args, 0, "home");
        try {
            Validator.validateHomeName(homeName);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            this.soundManager.playError(player);
            return true;
        }
        Location location = player.getLocation();
        try {
            Validator.validateLocation(location);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            this.soundManager.playError(player);
            return true;
        }
        if (this.plugin.getConfig().getBoolean("home.check-safe-location", true) && !Validator.isSafeLocation(location)) {
            this.msg.sendMessage((CommandSender)player, "validation.location-unsafe");
            this.soundManager.playWarning(player);
            if (!player.isSneaking()) {
                player.sendMessage(this.msg.colorize("&7&oAppuyez sur &eSHIFT &7&oet retapez la commande pour forcer."));
                return true;
            }
        }
        if (!(isUpdate = this.dataManager.homeExists(player.getUniqueId(), homeName))) {
            int maxHomes = this.getMaxHomes(player);
            int currentHomes = this.dataManager.getHomesCount(player.getUniqueId());
            if (currentHomes >= maxHomes) {
                this.msg.sendMessage((CommandSender)player, "teleport.home.limit-reached", this.msg.placeholder("limit", String.valueOf(maxHomes)), this.msg.placeholder("current", String.valueOf(currentHomes)));
                this.soundManager.playError(player);
                return true;
            }
        } else if (this.plugin.getConfig().getBoolean("home.show-overwrite-warning", true)) {
            this.msg.sendMessage((CommandSender)player, "teleport.home.overwrite-warning", this.msg.placeholder("home", homeName));
            this.soundManager.playWarning(player);
        }
        boolean chargeForUpdate = this.plugin.getConfig().getBoolean("economy.charge-for-update.home", false);
        if (!(isUpdate && !chargeForUpdate || this.checkEconomy(player, "home-set"))) {
            this.soundManager.playError(player);
            return true;
        }
        this.dataManager.setHome(player.getUniqueId(), homeName, location);
        this.effectsManager.playHomeCreatedEffect(location);
        this.soundManager.play(player, SoundManager.SoundType.HOME_SET);
        if (this.plugin.getConfig().getBoolean("messages.format.interactive-buttons", true)) {
            MessageFormatter.sendHomeCreatedMessage(player, homeName);
        } else if (isUpdate) {
            this.msg.sendMessage((CommandSender)player, "teleport.home.updated", this.msg.placeholder("home", homeName));
        } else {
            this.msg.sendMessage((CommandSender)player, "teleport.home.set", this.msg.placeholder("home", homeName));
        }
        if (this.plugin.getConfig().getBoolean("messages.format.action-bar.enabled", true)) {
            int current = this.dataManager.getHomesCount(player.getUniqueId());
            int max = this.getMaxHomes(player);
            String progress = MessageFormatter.createProgressBar(current, max, 10);
            MessageFormatter.sendActionBar(player, this.msg.colorize("&a\u2713 Home cr\u00e9\u00e9 ! " + progress));
        }
        if (!isUpdate && this.statsManager != null) {
            this.statsManager.incrementHomesCreated(player);
        }
        return true;
    }

    private int getMaxHomes(Player player) {
        if (player.hasPermission("mycommands.sethome.unlimited")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 100; i >= 1; --i) {
            if (!player.hasPermission("mycommands.sethome." + i)) continue;
            return i;
        }
        return this.plugin.getConfig().getInt("limits.max-homes", 3);
    }
}

