/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class RepairCommand
extends BaseCommand
implements TabCompleter {
    public RepairCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.repair");
        if (player == null) {
            return true;
        }
        if (!this.checkCooldown(player, "repair")) {
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("all")) {
            if (!player.hasPermission("mycommands.repair.all")) {
                this.msg.sendMessage((CommandSender)player, "general.no-permission");
                return true;
            }
            int repairedCount = this.repairAll(player);
            if (repairedCount == 0) {
                this.msg.sendMessage((CommandSender)player, "commands.repair.nothing-to-repair");
            } else {
                this.msg.sendMessage((CommandSender)player, "commands.repair.all-success", this.msg.placeholder("count", String.valueOf(repairedCount)));
            }
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            this.msg.sendMessage((CommandSender)player, "commands.repair.no-item");
            return true;
        }
        if (!this.isRepairable(item)) {
            this.msg.sendMessage((CommandSender)player, "commands.repair.not-repairable");
            return true;
        }
        this.repairItem(item);
        this.msg.sendMessage((CommandSender)player, "commands.repair.success", this.msg.placeholder("item", item.getType().name()));
        return true;
    }

    private int repairAll(Player player) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !this.isRepairable(item)) continue;
            this.repairItem(item);
            ++count;
        }
        for (ItemStack item : player.getInventory().getArmorContents()) {
            if (item == null || !this.isRepairable(item)) continue;
            this.repairItem(item);
            ++count;
        }
        return count;
    }

    private boolean isRepairable(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta instanceof Damageable && ((Damageable)meta).hasDamage();
    }

    private void repairItem(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof Damageable) {
            ((Damageable)meta).setDamage(0);
            item.setItemMeta(meta);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1 && sender.hasPermission("mycommands.repair.all")) {
            return Collections.singletonList("all");
        }
        return new ArrayList<String>();
    }
}

