/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.WeatherType;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PWeatherCommand
extends BaseCommand
implements TabCompleter {
    public PWeatherCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String weatherArg;
        Player target;
        if (!this.checkPermission(sender, "mycommands.pweather")) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/pweather <sun|rain|storm|reset> [joueur]");
            return true;
        }
        if (args.length >= 2) {
            if (!this.checkPermission(sender, "mycommands.pweather.others")) {
                return true;
            }
            target = this.plugin.getServer().getPlayer(args[1]);
            if (target == null) {
                this.msg.sendMessage(sender, "general.player-not-found");
                return true;
            }
            weatherArg = args[0];
        } else {
            target = this.getPlayer(sender);
            if (target == null) {
                return true;
            }
            weatherArg = args[0];
        }
        if (weatherArg.equalsIgnoreCase("reset")) {
            target.resetPlayerWeather();
            this.msg.sendMessage(sender, "commands.pweather.reset", this.msg.placeholder("player", target.getName()));
        } else {
            WeatherType weather = this.parseWeather(weatherArg);
            if (weather == null) {
                this.sendUsage(sender, "/pweather <sun|rain|storm|reset> [joueur]");
                return true;
            }
            target.setPlayerWeather(weather);
            this.msg.sendMessage(sender, "commands.pweather.set", this.msg.placeholder("player", target.getName()), this.msg.placeholder("weather", weatherArg));
        }
        return true;
    }

    private WeatherType parseWeather(String input) {
        switch (input.toLowerCase()) {
            case "sun": 
            case "clear": {
                return WeatherType.CLEAR;
            }
            case "rain": 
            case "storm": 
            case "thunder": {
                return WeatherType.DOWNFALL;
            }
        }
        return null;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> weathers = Arrays.asList("sun", "rain", "storm", "reset");
            return weathers.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("mycommands.pweather.others")) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

