/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.ConfirmationManager;
import fr.skynex.mycommands.managers.SoundManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DelHomeCommand
extends BaseCommand {
    private final ConfirmationManager confirmationManager;

    public DelHomeCommand(MyCommands plugin) {
        super(plugin);
        this.confirmationManager = plugin.getConfirmationManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.delhome");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/delhome <nom>");
            this.playError(player);
            return true;
        }
        String homeName = args[0];
        if (!this.dataManager.homeExists(player.getUniqueId(), homeName)) {
            this.msg.sendMessage((CommandSender)player, "teleport.home.not-found", this.msg.placeholder("home", homeName));
            this.playError(player);
            return true;
        }
        if (this.plugin.getConfig().getBoolean("confirmations.enabled", true) && this.plugin.getConfig().getBoolean("confirmations.require-for.home-delete", true)) {
            Long createdAt;
            int teleportCount = 0;
            if (this.statsManager != null) {
                teleportCount = this.statsManager.getHomeTeleports(player, homeName);
            }
            String createdDateStr = (createdAt = this.dataManager.getHomeCreatedAt(player.getUniqueId(), homeName)) != null ? this.formatHomeCreatedDate(createdAt) : this.msg.getMessage("confirmation.date-unknown");
            this.confirmationManager.requestHomeDelete(player, homeName, teleportCount, createdDateStr, () -> this.performHomeDeletion(player, homeName));
            return true;
        }
        this.performHomeDeletion(player, homeName);
        return true;
    }

    private String formatHomeCreatedDate(long timestamp) {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm", Locale.getDefault()).format(new Date(timestamp));
    }

    private void performHomeDeletion(Player player, String homeName) {
        this.dataManager.deleteHome(player.getUniqueId(), homeName);
        this.playHomeDeletedEffect(player.getLocation());
        this.playSuccess(player, SoundManager.SoundType.DELETE);
        this.msg.sendMessage((CommandSender)player, "teleport.home.deleted", this.msg.placeholder("home", homeName));
    }
}

