/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.service.jobs;

import com.skynex.mylands.service.jobs.JobsProvider;
import com.skynex.mylands.util.PluginLogger;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ExcellentJobsProvider
implements JobsProvider {
    private final Object jobsAPI = this.getJobsAPI();

    @Override
    @NotNull
    public String getName() {
        return "ExcellentJobs";
    }

    @Override
    public boolean isAvailable() {
        return this.jobsAPI != null;
    }

    private Object getJobsAPI() {
        try {
            Class<?> jobsApiClass = Class.forName("su.nightexpress.excellentjobs.api.JobsAPI");
            return jobsApiClass.getMethod("PLUGIN", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public CompletableFuture<Integer> getJobLevel(@NotNull Player player, @NotNull String jobName) {
        if (!this.isAvailable()) {
            return CompletableFuture.completedFuture(0);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                Class<?> jobsApiClass = Class.forName("su.nightexpress.excellentjobs.api.JobsAPI");
                Object plugin = jobsApiClass.getMethod("PLUGIN", new Class[0]).invoke(null, new Object[0]);
                Class<?> jobsPluginClass = Class.forName("su.nightexpress.excellentjobs.JobsPlugin");
                Object jobManager = jobsPluginClass.getMethod("getJobManager", new Class[0]).invoke(plugin, new Object[0]);
                Class<?> jobManagerClass = Class.forName("su.nightexpress.excellentjobs.job.impl.JobManager");
                Object job = jobManagerClass.getMethod("getJobById", String.class).invoke(jobManager, jobName.toLowerCase());
                if (job == null) {
                    return 0;
                }
                Object userData = jobsApiClass.getMethod("getUserData", Player.class).invoke(null, player);
                if (userData == null) {
                    return 0;
                }
                Class<?> userDataClass = Class.forName("su.nightexpress.excellentjobs.data.impl.JobUser");
                Class<?> jobClass = Class.forName("su.nightexpress.excellentjobs.job.impl.Job");
                Object jobData = userDataClass.getMethod("getData", jobClass).invoke(userData, job);
                if (jobData == null) {
                    return 0;
                }
                Class<?> jobDataClass = Class.forName("su.nightexpress.excellentjobs.data.impl.JobData");
                return (Integer)jobDataClass.getMethod("getLevel", new Class[0]).invoke(jobData, new Object[0]);
            }
            catch (Exception e) {
                PluginLogger.error("Error getting job level from ExcellentJobs", e);
                return 0;
            }
        });
    }

    @Override
    public CompletableFuture<Optional<String>> getPlayerJobsString(@NotNull Player player) {
        if (!this.isAvailable()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                Class<?> jobsApiClass = Class.forName("su.nightexpress.excellentjobs.api.JobsAPI");
                Object userData = jobsApiClass.getMethod("getUserData", Player.class).invoke(null, player);
                if (userData == null) {
                    return Optional.empty();
                }
                Class<?> userDataClass = Class.forName("su.nightexpress.excellentjobs.data.impl.JobUser");
                Map datas = (Map)userDataClass.getMethod("getDatas", new Class[0]).invoke(userData, new Object[0]);
                if (datas == null || datas.isEmpty()) {
                    return Optional.empty();
                }
                StringBuilder sb = new StringBuilder();
                Class<?> jobClass = Class.forName("su.nightexpress.excellentjobs.job.impl.Job");
                Class<?> jobDataClass = Class.forName("su.nightexpress.excellentjobs.data.impl.JobData");
                for (Map.Entry entry : datas.entrySet()) {
                    Object job = entry.getKey();
                    Object jobData = entry.getValue();
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    String jobName = (String)jobClass.getMethod("getName", new Class[0]).invoke(job, new Object[0]);
                    Integer level = (Integer)jobDataClass.getMethod("getLevel", new Class[0]).invoke(jobData, new Object[0]);
                    sb.append(jobName).append(" (lvl ").append(level).append(")");
                }
                return Optional.of(sb.toString());
            }
            catch (Exception e) {
                PluginLogger.error("Error getting player jobs from ExcellentJobs", e);
                return Optional.empty();
            }
        });
    }

    @Override
    public boolean jobExists(@NotNull String jobName) {
        if (!this.isAvailable()) {
            return false;
        }
        try {
            Class<?> jobsApiClass = Class.forName("su.nightexpress.excellentjobs.api.JobsAPI");
            Object plugin = jobsApiClass.getMethod("PLUGIN", new Class[0]).invoke(null, new Object[0]);
            Class<?> jobsPluginClass = Class.forName("su.nightexpress.excellentjobs.JobsPlugin");
            Object jobManager = jobsPluginClass.getMethod("getJobManager", new Class[0]).invoke(plugin, new Object[0]);
            Class<?> jobManagerClass = Class.forName("su.nightexpress.excellentjobs.job.impl.JobManager");
            Object job = jobManagerClass.getMethod("getJobById", String.class).invoke(jobManager, jobName.toLowerCase());
            return job != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void validateJobNames(@NotNull Iterable<String> jobNames) {
        if (!this.isAvailable()) {
            return;
        }
        for (String jobName : jobNames) {
            if (this.jobExists(jobName)) continue;
            PluginLogger.warn("Job '{}' referenced in config but not found in ExcellentJobs", jobName);
        }
    }
}

