/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.service;

import com.skynex.mylands.service.jobs.ExcellentJobsProvider;
import com.skynex.mylands.service.jobs.JobsProvider;
import com.skynex.mylands.service.jobs.JobsRebornProvider;
import com.skynex.mylands.util.PluginLogger;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobsService {
    private final JobsProvider provider;
    private final boolean enabled;

    public JobsService(boolean enabled) {
        this(enabled, "auto");
    }

    public JobsService(boolean enabled, @NotNull String preferredProvider) {
        if (!enabled) {
            this.provider = null;
            this.enabled = false;
            PluginLogger.info("Jobs integration disabled in configuration", new Object[0]);
            return;
        }
        JobsProvider detectedProvider = this.detectProvider(preferredProvider);
        if (detectedProvider != null && detectedProvider.isAvailable()) {
            this.provider = detectedProvider;
            this.enabled = true;
            PluginLogger.info("Jobs integration enabled with provider: {}", this.provider.getName());
        } else {
            this.provider = null;
            this.enabled = false;
            PluginLogger.warn("Jobs integration requested but no compatible plugin found", new Object[0]);
        }
    }

    @Nullable
    private JobsProvider detectProvider(@NotNull String preferredProvider) {
        ExcellentJobsProvider excellentJobs;
        ArrayList<JobsProvider> availableProviders = new ArrayList<JobsProvider>();
        JobsRebornProvider jobsReborn = new JobsRebornProvider();
        if (jobsReborn.isAvailable()) {
            availableProviders.add(jobsReborn);
        }
        if ((excellentJobs = new ExcellentJobsProvider()).isAvailable()) {
            availableProviders.add(excellentJobs);
        }
        if (availableProviders.isEmpty()) {
            return null;
        }
        if (preferredProvider.equalsIgnoreCase("auto")) {
            JobsProvider selected = (JobsProvider)availableProviders.get(0);
            if (availableProviders.size() > 1) {
                PluginLogger.info("Multiple jobs plugins detected, using: {}", selected.getName());
            }
            return selected;
        }
        for (JobsProvider provider : availableProviders) {
            if (!provider.getName().equalsIgnoreCase(preferredProvider)) continue;
            PluginLogger.info("Using preferred jobs provider: {}", provider.getName());
            return provider;
        }
        PluginLogger.warn("Preferred provider '{}' not found, using: {}", preferredProvider, ((JobsProvider)availableProviders.get(0)).getName());
        return (JobsProvider)availableProviders.get(0);
    }

    public boolean isEnabled() {
        return this.enabled && this.provider != null;
    }

    @NotNull
    public String getProviderName() {
        return this.provider != null ? this.provider.getName() : "None";
    }

    public CompletableFuture<Integer> getJobLevel(@NotNull Player player, @NotNull String jobName) {
        if (!this.isEnabled()) {
            return CompletableFuture.completedFuture(0);
        }
        return this.provider.getJobLevel(player, jobName);
    }

    public CompletableFuture<Boolean> meetsJobRequirement(@NotNull Player player, @NotNull String jobName, int requiredLevel) {
        if (!this.isEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.meetsJobRequirement(player, jobName, requiredLevel);
    }

    public CompletableFuture<Optional<String>> getPlayerJobsString(@NotNull Player player) {
        if (!this.isEnabled()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return this.provider.getPlayerJobsString(player);
    }

    public boolean jobExists(@NotNull String jobName) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.provider.jobExists(jobName);
    }

    public void validateJobNames(@NotNull Iterable<String> jobNames) {
        if (!this.isEnabled()) {
            return;
        }
        this.provider.validateJobNames(jobNames);
    }
}

