/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.service;

import com.skynex.mylands.model.ActivityLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class ActivityLogService {
    private final Map<UUID, List<ActivityLog>> landLogs = new ConcurrentHashMap<UUID, List<ActivityLog>>();

    @NotNull
    public List<ActivityLog> getLogs(@NotNull UUID landId) {
        return this.landLogs.getOrDefault(landId, new ArrayList());
    }

    @NotNull
    public List<ActivityLog> getLogs(@NotNull UUID landId, int page, int pageSize) {
        List<ActivityLog> allLogs = this.getLogs(landId);
        int startIndex = page * pageSize;
        int endIndex = Math.min(startIndex + pageSize, allLogs.size());
        if (startIndex >= allLogs.size()) {
            return new ArrayList<ActivityLog>();
        }
        return new ArrayList<ActivityLog>(allLogs.subList(startIndex, endIndex));
    }

    public void addLog(@NotNull UUID landId, @NotNull ActivityLog log) {
        this.landLogs.computeIfAbsent(landId, k -> new ArrayList()).add(log);
        List<ActivityLog> logs = this.landLogs.get(landId);
        if (logs.size() > 1000) {
            this.landLogs.put(landId, new ArrayList<ActivityLog>(logs.subList(logs.size() - 1000, logs.size())));
        }
    }

    public void logLandCreation(@NotNull UUID landId, @NotNull UUID playerId, @NotNull String playerName, @NotNull String landName) {
        ActivityLog log = new ActivityLog(playerId, "CREATE", "Created land: " + landName, System.currentTimeMillis());
        this.addLog(landId, log);
    }

    public void logLandUpgrade(@NotNull UUID landId, @NotNull UUID playerId, @NotNull String playerName, int oldLevel, int newLevel) {
        ActivityLog log = new ActivityLog(playerId, "UPGRADE", "Upgraded land from level " + oldLevel + " to " + newLevel, System.currentTimeMillis());
        this.addLog(landId, log);
    }

    public void logCoOwnerAdded(@NotNull UUID landId, @NotNull UUID playerId, @NotNull String ownerName, @NotNull String coOwnerName) {
        ActivityLog log = new ActivityLog(playerId, "MEMBER", "Added co-owner: " + coOwnerName, System.currentTimeMillis());
        this.addLog(landId, log);
    }

    public void logCoOwnerRemoved(@NotNull UUID landId, @NotNull UUID playerId, @NotNull String ownerName, @NotNull String coOwnerName) {
        ActivityLog log = new ActivityLog(playerId, "MEMBER", "Removed co-owner: " + coOwnerName, System.currentTimeMillis());
        this.addLog(landId, log);
    }

    public void logVisit(@NotNull UUID landId, @NotNull UUID playerId, @NotNull String visitorName) {
        ActivityLog log = new ActivityLog(playerId, "VISIT", "Visited the land", System.currentTimeMillis());
        this.addLog(landId, log);
    }

    public int getLogCount(@NotNull UUID landId) {
        return this.getLogs(landId).size();
    }

    public void clearLogs(@NotNull UUID landId) {
        this.landLogs.remove(landId);
    }
}

