/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public record QuestProgress(@NotNull UUID playerId, @NotNull String questId, int currentAmount, boolean completed, @NotNull Instant startedAt, Instant completedAt, @NotNull UUID landId, @NotNull Map<UUID, Integer> contributions) {
    public static QuestProgress start(@NotNull UUID playerId, @NotNull String questId) {
        return new QuestProgress(playerId, questId, 0, false, Instant.now(), null, null, new ConcurrentHashMap<UUID, Integer>());
    }

    public static QuestProgress startCollaborative(@NotNull UUID landId, @NotNull String questId) {
        return new QuestProgress(null, questId, 0, false, Instant.now(), null, landId, new ConcurrentHashMap<UUID, Integer>());
    }

    public QuestProgress increment(int amount) {
        return new QuestProgress(this.playerId, this.questId, this.currentAmount + amount, this.completed, this.startedAt, this.completedAt, this.landId, this.contributions);
    }

    public QuestProgress increment(@NotNull UUID contributorId, int amount) {
        ConcurrentHashMap<UUID, Integer> newContributions = new ConcurrentHashMap<UUID, Integer>(this.contributions);
        newContributions.merge(contributorId, amount, (oldVal, newVal) -> oldVal + newVal);
        return new QuestProgress(this.playerId, this.questId, this.currentAmount + amount, this.completed, this.startedAt, this.completedAt, this.landId, newContributions);
    }

    public QuestProgress complete() {
        return new QuestProgress(this.playerId, this.questId, this.currentAmount, true, this.startedAt, Instant.now(), this.landId, this.contributions);
    }

    public boolean isCollaborative() {
        return this.landId != null;
    }

    public int getContribution(@NotNull UUID playerId) {
        return this.contributions.getOrDefault(playerId, 0);
    }

    public List<UUID> getActiveContributors(int minContributions) {
        return this.contributions.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= minContributions).map(Map.Entry::getKey).toList();
    }

    public int getProgressPercentage(int targetAmount) {
        if (targetAmount == 0) {
            return 100;
        }
        return Math.min(100, this.currentAmount * 100 / targetAmount);
    }

    public boolean isStartedToday() {
        LocalDate today = LocalDate.now();
        LocalDate startDate = this.startedAt.atZone(ZoneId.systemDefault()).toLocalDate();
        return today.equals(startDate);
    }

    public boolean isCompletedToday() {
        if (this.completedAt == null) {
            return false;
        }
        LocalDate today = LocalDate.now();
        LocalDate completeDate = this.completedAt.atZone(ZoneId.systemDefault()).toLocalDate();
        return today.equals(completeDate);
    }

    public boolean isExpired(boolean isDaily, boolean isWeekly) {
        if (!isDaily && !isWeekly) {
            return false;
        }
        LocalDate today = LocalDate.now();
        LocalDate startDate = this.startedAt.atZone(ZoneId.systemDefault()).toLocalDate();
        if (isDaily) {
            return !today.equals(startDate);
        }
        if (isWeekly) {
            return today.minusDays(7L).isAfter(startDate);
        }
        return false;
    }
}

