/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.model;

import org.jetbrains.annotations.NotNull;

public enum LandPermission {
    BUILD("Build", "\u00a7aPlace and break blocks", "GRASS_BLOCK"),
    INTERACT("Interact", "\u00a7bUse doors, buttons, levers", "OAK_DOOR"),
    ANIMALS("Animals", "\u00a7eKill and breed animals", "WHEAT"),
    CROPS("Crops", "\u00a72Harvest and plant crops", "WHEAT_SEEDS"),
    CONTAINERS("Containers", "\u00a76Access chests and storage", "CHEST"),
    REDSTONE("Redstone", "\u00a7cUse redstone mechanisms", "REDSTONE"),
    INVITE("Invite", "\u00a7dInvite players to the land", "PLAYER_HEAD"),
    KICK("Kick", "\u00a7cKick members from the land", "BARRIER"),
    MANAGE_GRADES("Manage Grades", "\u00a75Create and edit grades", "NAME_TAG"),
    TELEPORT("Teleport", "\u00a7bTeleport to the land", "ENDER_PEARL"),
    SET_HOME("Set Home", "\u00a7aSet the land home point", "RED_BED"),
    SETTINGS("Settings", "\u00a76Modify land settings", "COMPARATOR"),
    UPGRADE("Upgrade", "\u00a7eUpgrade the land level", "EXPERIENCE_BOTTLE"),
    DELETE("Delete", "\u00a74Delete the land", "TNT");

    private final String displayName;
    private final String description;
    private final String iconMaterial;

    private LandPermission(@NotNull String displayName, String description, String iconMaterial) {
        this.displayName = displayName;
        this.description = description;
        this.iconMaterial = iconMaterial;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getIconMaterial() {
        return this.iconMaterial;
    }

    @NotNull
    public String getColoredName() {
        return this.description.split(" ")[0] + " \u00a7f" + this.displayName;
    }
}

