/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.GuiConfig;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.model.Grade;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.service.GradeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class ConfigurableMembersGui
implements LandGui {
    private static final String GUI_NAME = "members_menu";
    private final GuiConfig guiConfig;
    private final Land land;
    private final GradeService gradeService;
    private final int page;

    public ConfigurableMembersGui(@NotNull GuiConfig guiConfig, @NotNull Land land, @NotNull GradeService gradeService) {
        this(guiConfig, land, gradeService, 0);
    }

    public ConfigurableMembersGui(@NotNull GuiConfig guiConfig, @NotNull Land land, @NotNull GradeService gradeService, int page) {
        this.guiConfig = guiConfig;
        this.land = land;
        this.gradeService = gradeService;
        this.page = page;
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(), (String)this.getTitle());
        this.displayMembers(inv);
        this.createItem(inv, "add_member");
        this.createItem(inv, "back");
        return inv;
    }

    private void displayMembers(@NotNull Inventory inv) {
        ArrayList<UUID> members = new ArrayList<UUID>(this.land.coOwners());
        int startIndex = this.page * 45;
        int endIndex = Math.min(startIndex + 45, members.size());
        int maxIndex = Math.min(endIndex, members.size());
        for (int i = startIndex; i < maxIndex; ++i) {
            UUID memberId = (UUID)members.get(i);
            OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)memberId);
            Grade memberGrade = this.gradeService.getMemberGrade(this.land.ownerId(), memberId);
            ItemStack item = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)item.getItemMeta();
            if (meta != null) {
                meta.setOwningPlayer(member);
                meta.setDisplayName("\u00a7b\u00a7l" + member.getName());
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                lore.add("\u00a77UUID: \u00a7e" + memberId.toString().substring(0, 8) + "...");
                lore.add("\u00a77Status: " + (member.isOnline() ? "\u00a7aOnline" : "\u00a77Offline"));
                if (memberGrade != null) {
                    lore.add("\u00a77Grade: " + memberGrade.getColoredName());
                    lore.add("\u00a77Permissions: \u00a7e" + memberGrade.permissions().size());
                }
                lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                lore.add("");
                lore.add("\u00a7e\u25b6 Left-click: \u00a77Change grade");
                lore.add("\u00a7c\u25b6 Right-click: \u00a77Remove member");
                meta.setLore(lore);
                item.setItemMeta((ItemMeta)meta);
            }
            inv.setItem(i - startIndex, item);
        }
    }

    private void createItem(@NotNull Inventory inv, @NotNull String itemName) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, itemName);
        if (itemConfig == null) {
            return;
        }
        Map<String, String> placeholders = this.getPlaceholders();
        ItemStack item = new ItemStack(itemConfig.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String name = itemConfig.getName();
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                name = name.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            meta.setDisplayName(name);
            meta.setLore(itemConfig.getLore(placeholders));
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    private Map<String, String> getPlaceholders() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("coowners", String.valueOf(this.land.coOwners().size()));
        int maxCoOwners = 5;
        placeholders.put("max_coowners", String.valueOf(maxCoOwners));
        return placeholders;
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        ArrayList<UUID> members;
        int memberIndex;
        if (slot >= 0 && slot < 45 && (memberIndex = this.page * 45 + slot) < (members = new ArrayList<UUID>(this.land.coOwners())).size()) {
            UUID memberId = (UUID)members.get(memberIndex);
            OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)memberId);
            if (clickType.isLeftClick()) {
                player.closeInventory();
                player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                player.sendMessage("\u00a76\u00a7lChange Grade for \u00a7f" + member.getName());
                player.sendMessage("\u00a77Use: \u00a7e/lands grade assign " + member.getName() + " <gradeId>");
                player.sendMessage("\u00a77Available grades: \u00a7e/lands grade list");
                player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            } else if (clickType.isRightClick()) {
                player.closeInventory();
                player.performCommand("lands remove " + member.getName());
            }
            return;
        }
        String itemName = this.getItemNameBySlot(slot);
        if (itemName == null) {
            return;
        }
        switch (itemName) {
            case "add_member": {
                this.handleAddMember(player);
                break;
            }
            case "back": {
                this.handleBack(player);
            }
        }
    }

    private String getItemNameBySlot(int slot) {
        String[] items;
        for (String itemName : items = new String[]{"add_member", "back"}) {
            GuiConfig.GuiItemConfig config = this.guiConfig.getItem(GUI_NAME, itemName);
            if (config == null || config.getSlot() != slot) continue;
            return itemName;
        }
        return null;
    }

    private void handleAddMember(Player player) {
        player.closeInventory();
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a76\u00a7l\ud83d\udc65 Invite a Member");
        player.sendMessage("\u00a77Type the player name in chat:");
        player.sendMessage("\u00a7e/lands invite <player>");
        player.sendMessage("\u00a77Or type \u00a7ccancel \u00a77to cancel");
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    private void handleBack(Player player) {
        player.closeInventory();
        player.performCommand("lands menu");
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.guiConfig.getTitle(GUI_NAME).replace("&", "\u00a7");
    }

    @Override
    public int getSize() {
        return this.guiConfig.getSize(GUI_NAME);
    }
}

