/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.config;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestConfig {
    private final Map<String, Object> config;

    private static void dbg(String loc, String msg, String data, String hid) {
        try {
            String d = data != null ? "\"" + data.replace("\\", "\\\\").replace("\"", "\\\"") + "\"" : "{}";
            String json = "{\"location\":\"" + loc + "\",\"message\":\"" + msg.replace("\\", "\\\\").replace("\"", "\\\"") + "\",\"data\":{\"val\":" + d + "},\"hypothesisId\":\"" + hid + "\",\"timestamp\":" + System.currentTimeMillis() + "}";
            Files.write(Paths.get("c:\\Users\\killi\\IdeaProjects\\MyCommands\\.cursor\\debug.log", new String[0]), (json + "\n").getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public QuestConfig(@NotNull Map<String, Object> config) {
        this.config = config;
    }

    @NotNull
    public Map<String, List<QuestData>> getAllQuests() {
        HashMap<String, List<QuestData>> allQuests = new HashMap<String, List<QuestData>>();
        Object questsObj = this.config.get("quests");
        QuestConfig.dbg("QuestConfig.java:35", "questsObj type", questsObj != null ? questsObj.getClass().getName() : "null", "H1");
        if (questsObj instanceof Map) {
            Map questsMap = (Map)questsObj;
            QuestConfig.dbg("QuestConfig.java:38", "Map branch", "size=" + questsMap.size(), "H4");
            System.out.println("[QuestConfig] Found quests map with " + questsMap.size() + " entries");
            for (Map.Entry entry : questsMap.entrySet()) {
                String questType = this.getString(entry.getKey());
                Object questTypeData = entry.getValue();
                System.out.println("[QuestConfig] Processing quest type: " + questType);
                if (!(questTypeData instanceof Map)) continue;
                Map typeMap = (Map)questTypeData;
                QuestConfig.dbg("QuestConfig.java:46", "typeMap size", String.valueOf(typeMap.size()), "H2");
                ArrayList<QuestData> questList = new ArrayList<QuestData>();
                for (Map.Entry questEntry : typeMap.entrySet()) {
                    String questId = this.getString(questEntry.getKey());
                    Object qVal = questEntry.getValue();
                    QuestConfig.dbg("QuestConfig.java:51", "questData class (Map branch)", qVal != null ? qVal.getClass().getName() : "null", "H1");
                    QuestData questData = this.parseQuestData(questId, qVal);
                    if (questData == null) continue;
                    questList.add(questData);
                    System.out.println("[QuestConfig] Loaded quest: " + questId);
                }
                allQuests.put(questType, questList);
                System.out.println("[QuestConfig] Added " + questList.size() + " quests for type: " + questType);
            }
        } else if (questsObj instanceof ConfigurationSection) {
            ConfigurationSection questsSection = (ConfigurationSection)questsObj;
            int keys = questsSection.getKeys(false).size();
            QuestConfig.dbg("QuestConfig.java:62", "ConfigurationSection branch", "keys=" + keys, "H4");
            System.out.println("[QuestConfig] Found ConfigurationSection with " + keys + " entries");
            for (String questType : questsSection.getKeys(false)) {
                Object questTypeData = questsSection.get(questType);
                System.out.println("[QuestConfig] Processing quest type: " + questType);
                if (!(questTypeData instanceof ConfigurationSection)) continue;
                ConfigurationSection typeSection = (ConfigurationSection)questTypeData;
                Set questKeys = typeSection.getKeys(false);
                QuestConfig.dbg("QuestConfig.java:72", "typeSection quest keys count", String.valueOf(questKeys.size()) + " keys=" + String.valueOf(questKeys), "H2");
                ArrayList<QuestData> questList = new ArrayList<QuestData>();
                for (String questId : questKeys) {
                    Object questData = typeSection.get(questId);
                    QuestConfig.dbg("QuestConfig.java:76", "questData class (ConfigSection branch)", questData != null ? questData.getClass().getName() : "null", "H1");
                    QuestData parsedQuest = this.parseQuestData(questId, questData);
                    if (parsedQuest == null) continue;
                    questList.add(parsedQuest);
                    System.out.println("[QuestConfig] Loaded quest: " + questId);
                }
                allQuests.put(questType, questList);
                System.out.println("[QuestConfig] Added " + questList.size() + " quests for type: " + questType);
            }
        } else {
            System.out.println("[QuestConfig] No quests map found or wrong type: " + (questsObj != null ? questsObj.getClass().getName() : "null"));
        }
        System.out.println("[QuestConfig] Returning " + allQuests.size() + " quest types");
        return allQuests;
    }

    @NotNull
    public List<String> getQuestTypes() {
        Object questTypesObj = this.config.get("quest_types");
        if (questTypesObj instanceof List) {
            List questTypesList = (List)questTypesObj;
            ArrayList<String> types = new ArrayList<String>();
            for (Object type : questTypesList) {
                if (!(type instanceof String)) continue;
                types.add((String)type);
            }
            return types;
        }
        return List.of("harvest_crops", "break_blocks", "place_blocks", "login_daily", "invite_members", "enable_visits", "reach_level");
    }

    @NotNull
    public Map<String, RewardConfig> getRewards() {
        HashMap<String, RewardConfig> rewards = new HashMap<String, RewardConfig>();
        Object rewardsObj = this.config.get("rewards");
        if (rewardsObj instanceof Map) {
            Map rewardsMap = (Map)rewardsObj;
            for (Map.Entry entry : rewardsMap.entrySet()) {
                String rewardType = this.getString(entry.getKey());
                Object rewardData = entry.getValue();
                if (!(rewardData instanceof Map)) continue;
                Map rewardMap = (Map)rewardData;
                String command = this.getString(rewardMap.get("command"));
                String message = this.getString(rewardMap.get("message"));
                if (command == null || message == null) continue;
                rewards.put(rewardType, new RewardConfig(command, message));
            }
        }
        return rewards;
    }

    @NotNull
    public Map<String, String> getMessages() {
        HashMap<String, String> messages = new HashMap<String, String>();
        Object messagesObj = this.config.get("messages");
        if (messagesObj instanceof Map) {
            Map messagesMap = (Map)messagesObj;
            for (Map.Entry entry : messagesMap.entrySet()) {
                String key = this.getString(entry.getKey());
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                messages.put(key, (String)value);
            }
        }
        if (!messages.containsKey("quest_completed")) {
            messages.put("quest_completed", "&a&l\u2714 Qu\u00eate Termin\u00e9e !");
        }
        if (!messages.containsKey("quest_already_completed")) {
            messages.put("quest_already_completed", "&cCette qu\u00eate est d\u00e9j\u00e0 termin\u00e9e.");
        }
        if (!messages.containsKey("quest_not_found")) {
            messages.put("quest_not_found", "&cQu\u00eate introuvable.");
        }
        if (!messages.containsKey("quest_disabled")) {
            messages.put("quest_disabled", "&cCette qu\u00eate est d\u00e9sactiv\u00e9e.");
        }
        if (!messages.containsKey("level_required")) {
            messages.put("level_required", "&cVous devez \u00eatre niveau %required_level% pour cette qu\u00eate.");
        }
        if (!messages.containsKey("daily_reset")) {
            messages.put("daily_reset", "&7Les qu\u00eates quotidiennes ont \u00e9t\u00e9 r\u00e9initialis\u00e9es.");
        }
        if (!messages.containsKey("quest_started")) {
            messages.put("quest_started", "&e&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        }
        if (!messages.containsKey("quest_progress")) {
            messages.put("quest_progress", "&7Progression: %current%/%target%");
        }
        return messages;
    }

    @Nullable
    private QuestData parseQuestData(@NotNull String questId, @NotNull Object questData) {
        Map questMap;
        System.out.println("[QuestConfig] Parsing quest data for: " + questId);
        System.out.println("[QuestConfig] Quest data type: " + questData.getClass().getName());
        if (questData instanceof ConfigurationSection) {
            Map m4;
            ConfigurationSection section = (ConfigurationSection)questData;
            questMap = m4 = section.getValues(true);
        } else if (questData instanceof Map) {
            Map m5;
            Map typed;
            questMap = typed = (m5 = (Map)questData);
        } else {
            String typeName = questData != null ? questData.getClass().getName() : "null";
            QuestConfig.dbg("QuestConfig.java:205", "parseQuestData: questData neither Map nor ConfigSection", typeName, "H1");
            return null;
        }
        try {
            System.out.println("[QuestConfig] Quest map keys: " + String.valueOf(questMap.keySet()));
            String name = this.getString(questMap.get("name"));
            String description = this.getString(questMap.get("description"));
            String materialStr = this.getString(questMap.get("material"));
            String icon = this.getString(questMap.get("icon"));
            Boolean enabled = this.getBoolean(questMap.get("enabled"));
            Boolean dailyReset = this.getBoolean(questMap.get("daily_reset"));
            Integer requiredLevel = this.getInteger(questMap.get("required_level"));
            Integer reward = this.getInteger(questMap.get("reward"));
            String rewardType = this.getString(questMap.get("reward_type"));
            System.out.println("[QuestConfig] Parsed values - name: " + name + ", enabled: " + enabled + ", reward: " + reward);
            Object objectivesObj = questMap.get("objectives");
            ArrayList<String> objectives = new ArrayList<String>();
            if (objectivesObj instanceof List) {
                List objectivesList = (List)objectivesObj;
                for (Object obj : objectivesList) {
                    if (!(obj instanceof String)) continue;
                    objectives.add((String)obj);
                }
            }
            System.out.println("[QuestConfig] Objectives found: " + objectives.size());
            Material material = this.parseMaterial(materialStr);
            System.out.println("[QuestConfig] Material parsed: " + String.valueOf(material));
            QuestData result = new QuestData(questId, name, description, material, icon, objectives, reward, rewardType, enabled != null ? enabled : true, dailyReset != null ? dailyReset : false, requiredLevel != null ? requiredLevel : 1);
            System.out.println("[QuestConfig] Successfully parsed quest: " + questId);
            return result;
        }
        catch (Exception e) {
            System.out.println("[QuestConfig] Error parsing quest " + questId + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    private String getString(@Nullable Object obj) {
        return obj instanceof String ? (String)obj : null;
    }

    private boolean getBoolean(@Nullable Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        return false;
    }

    @Nullable
    private Integer getInteger(@Nullable Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    private Material parseMaterial(@Nullable String materialStr) {
        if (materialStr == null) {
            return Material.PAPER;
        }
        try {
            return Material.valueOf((String)materialStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Material.PAPER;
        }
    }

    public record QuestData(@NotNull String id, @NotNull String name, @NotNull String description, @NotNull Material material, @NotNull String icon, @NotNull List<String> objectives, int reward, @NotNull String rewardType, boolean enabled, boolean dailyReset, int requiredLevel) {
    }

    public record RewardConfig(@NotNull String command, @NotNull String message) {
    }
}

