/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.config;

import com.skynex.mylands.config.Messages;
import com.skynex.mylands.gui.GuiConfig;
import com.skynex.mylands.model.JobRequirement;
import com.skynex.mylands.model.LandLevel;
import com.skynex.mylands.util.PluginLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    private final Plugin plugin;
    private FileConfiguration config;
    private FileConfiguration guisConfig;
    private FileConfiguration questsConfig;
    private GuiConfig guiConfig;
    private String language;
    private int initialSize;
    private int heightLimit;
    private int depthLimit;
    private int minFarmSize;
    private int maxFarmSize;
    private int maxFarmNameLength;
    private int sizeIncreasePerLevel;
    private int creationCost;
    private int deletionRefundPercent;
    private int maxLevel;
    private int maxCoOwners;
    private Particle zoneDisplayParticle;
    private int zoneDisplayDuration;
    private Material zoneDisplayBlock;
    private boolean economyEnabled;
    private boolean jobsEnabled;
    private final Map<Integer, LandLevel> landLevels = new HashMap<Integer, LandLevel>();
    private final Messages messages;
    private String jobsProvider;

    public ConfigManager(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.messages = new Messages();
        this.loadConfigs();
    }

    public void loadConfigs() {
        String[] languages;
        this.plugin.saveDefaultConfig();
        this.saveResourceIfNotExists("guis.yml");
        this.saveResourceIfNotExists("gui_quests.yml");
        for (String lang : languages = new String[]{"ar", "bn", "en", "es", "fr", "hi", "id", "pt", "ru", "zh"}) {
            this.saveResourceIfNotExists("languages/messages_" + lang + ".yml");
        }
        this.config = this.plugin.getConfig();
        this.guisConfig = this.loadConfigFile("guis.yml");
        this.questsConfig = this.loadConfigFile("gui_quests.yml");
        this.guiConfig = new GuiConfig(this.guisConfig);
        this.language = this.config.getString("language", "fr");
        this.loadFarmSettings();
        this.loadCoOwnershipSettings();
        this.loadVisualSettings();
        this.loadEconomySettings();
        this.loadJobsSettings();
        this.loadUpgradeLevels();
        this.loadMessages();
        PluginLogger.info("Configuration loaded successfully (language: {})", this.language);
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.loadConfigs();
        PluginLogger.info("Configuration reloaded", new Object[0]);
    }

    private void loadFarmSettings() {
        this.initialSize = Math.max(16, Math.min(256, this.config.getInt("land.initial_size", 64)));
        this.heightLimit = Math.max(100, Math.min(320, this.config.getInt("land.height_limit", 319)));
        this.depthLimit = Math.max(-64, Math.min(100, this.config.getInt("land.depth_limit", 0)));
        this.minFarmSize = Math.max(16, Math.min(this.initialSize, this.config.getInt("land.min_size", 32)));
        this.maxFarmSize = Math.max(this.initialSize, Math.min(512, this.config.getInt("land.max_size", 110)));
        this.maxFarmNameLength = Math.max(3, Math.min(64, this.config.getInt("land.max_name_length", 32)));
        this.sizeIncreasePerLevel = Math.max(1, Math.min(50, this.config.getInt("land.size_increase_per_level", 5)));
        this.creationCost = Math.max(0, this.config.getInt("land.creation_cost", 10000));
        this.deletionRefundPercent = Math.max(0, Math.min(100, this.config.getInt("land.deletion_refund_percent", 50)));
        this.maxLevel = Math.max(1, Math.min(100, this.config.getInt("land.max_level", 10)));
        if (this.minFarmSize > this.maxFarmSize) {
            PluginLogger.warn("min_size ({}) > max_size ({}), using defaults", this.minFarmSize, this.maxFarmSize);
            this.minFarmSize = 32;
            this.maxFarmSize = 110;
        }
        if (this.initialSize < this.minFarmSize || this.initialSize > this.maxFarmSize) {
            PluginLogger.warn("initial_size ({}) out of bounds [{}, {}], using default", this.initialSize, this.minFarmSize, this.maxFarmSize);
            this.initialSize = Math.max(this.minFarmSize, Math.min(this.maxFarmSize, 64));
        }
        PluginLogger.debug("Land settings loaded: initialSize={}, heightLimit={}, maxLevel={}", this.initialSize, this.heightLimit, this.maxLevel);
    }

    private void loadCoOwnershipSettings() {
        this.maxCoOwners = Math.max(1, Math.min(50, this.config.getInt("co_ownership.max_co_owners", 5)));
    }

    private void loadVisualSettings() {
        String particleStr = this.config.getString("visual.zone_display_particle", "ENCHANT");
        try {
            this.zoneDisplayParticle = Particle.valueOf((String)particleStr);
        }
        catch (IllegalArgumentException e) {
            PluginLogger.warn("Invalid particle '{}', using ENCHANT", particleStr);
            this.zoneDisplayParticle = Particle.ENCHANT;
        }
        this.zoneDisplayDuration = Math.max(1, Math.min(60, this.config.getInt("visual.zone_display_duration", 5)));
        String blockStr = this.config.getString("visual.zone_display_block", "RED_WOOL");
        try {
            this.zoneDisplayBlock = Material.valueOf((String)blockStr);
        }
        catch (IllegalArgumentException e) {
            PluginLogger.warn("Invalid material '{}', using RED_WOOL", blockStr);
            this.zoneDisplayBlock = Material.RED_WOOL;
        }
    }

    private void loadEconomySettings() {
        this.economyEnabled = this.config.getBoolean("economy.enabled", true);
    }

    private void loadJobsSettings() {
        this.jobsEnabled = this.config.getBoolean("jobs.enabled", false);
        this.jobsProvider = this.config.getString("jobs.provider", "auto");
    }

    public String getJobsProvider() {
        return this.jobsProvider;
    }

    private void loadUpgradeLevels() {
        this.landLevels.clear();
        ConfigurationSection levelRequirementsSection = this.config.getConfigurationSection("jobs.level_requirements");
        if (levelRequirementsSection == null) {
            PluginLogger.warn("No jobs.level_requirements section found in config", new Object[0]);
            return;
        }
        for (String levelKey : levelRequirementsSection.getKeys(false)) {
            try {
                List jobList;
                int level = Integer.parseInt(levelKey.replace("lvl", ""));
                ConfigurationSection levelSection = levelRequirementsSection.getConfigurationSection(levelKey);
                if (levelSection == null) {
                    PluginLogger.warn("No configuration found for level: {}", levelKey);
                    continue;
                }
                int cost = levelSection.getInt("cost", 0);
                int sizeIncrease = (level - 1) * this.sizeIncreasePerLevel;
                ArrayList<JobRequirement> jobRequirements = new ArrayList<JobRequirement>();
                if (this.jobsEnabled && (jobList = levelSection.getList("jobs")) != null) {
                    for (Object jobObj : jobList) {
                        if (!(jobObj instanceof Map)) continue;
                        Map jobMap = (Map)jobObj;
                        String jobName = (String)jobMap.get("job");
                        int requiredLevel = ((Number)jobMap.get("level")).intValue();
                        jobRequirements.add(new JobRequirement(jobName, requiredLevel));
                    }
                }
                LandLevel landLevel = new LandLevel(level, cost, sizeIncrease, jobRequirements);
                this.landLevels.put(level, landLevel);
                PluginLogger.debug("Loaded farm level {}: cost={}, sizeIncrease={}, jobReqs={}", level, cost, sizeIncrease, jobRequirements.size());
            }
            catch (NumberFormatException e) {
                PluginLogger.warn("Invalid level format: {}", levelKey);
            }
        }
        PluginLogger.info("Loaded {} land levels", this.landLevels.size());
    }

    private void loadMessages() {
        String messagesFile = "languages/messages_" + this.language + ".yml";
        FileConfiguration messagesConfig = this.loadConfigFile(messagesFile);
        if (messagesConfig == null) {
            PluginLogger.warn("Messages file not found: {}, falling back to messages_fr.yml", messagesFile);
            messagesConfig = this.loadConfigFile("languages/messages_fr.yml");
        }
        if (messagesConfig == null) {
            PluginLogger.error("Failed to load messages!", new Object[0]);
            return;
        }
        for (String key : messagesConfig.getKeys(false)) {
            String message = messagesConfig.getString(key);
            if (message == null) continue;
            this.messages.setMessage(key, message);
        }
        PluginLogger.info("Loaded {} messages from {}", this.messages.size(), messagesFile);
    }

    private FileConfiguration loadConfigFile(@NotNull String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            this.plugin.saveResource(fileName, false);
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private void saveResourceIfNotExists(@NotNull String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            this.plugin.saveResource(fileName, false);
        }
    }

    public int calculateLandSize(int level) {
        int sizeIncrease = (level - 1) * this.sizeIncreasePerLevel;
        return Math.min(this.initialSize + sizeIncrease, this.maxFarmSize);
    }

    public int calculateDeletionRefund(int landLevel) {
        int totalCost = this.creationCost;
        for (int lvl = 2; lvl <= landLevel; ++lvl) {
            Optional<LandLevel> levelConfig = this.getLandLevel(lvl);
            if (!levelConfig.isPresent()) continue;
            totalCost += levelConfig.get().upgradeCost();
        }
        return totalCost * this.deletionRefundPercent / 100;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getHeightLimit() {
        return this.heightLimit;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public int getMinFarmSize() {
        return this.minFarmSize;
    }

    public int getMaxFarmSize() {
        return this.maxFarmSize;
    }

    public int getMaxFarmNameLength() {
        return this.maxFarmNameLength;
    }

    public int getSizeIncreasePerLevel() {
        return this.sizeIncreasePerLevel;
    }

    public int getCreationCost() {
        return this.creationCost;
    }

    public int getDeletionRefundPercent() {
        return this.deletionRefundPercent;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMaxCoOwners() {
        return this.maxCoOwners;
    }

    public Particle getZoneDisplayParticle() {
        return this.zoneDisplayParticle;
    }

    public int getZoneDisplayDuration() {
        return this.zoneDisplayDuration;
    }

    public Material getZoneDisplayBlock() {
        return this.zoneDisplayBlock;
    }

    public boolean isEconomyEnabled() {
        return this.economyEnabled;
    }

    public boolean isJobsEnabled() {
        return this.jobsEnabled;
    }

    public Optional<LandLevel> getLandLevel(int level) {
        return Optional.ofNullable(this.landLevels.get(level));
    }

    public FileConfiguration getDatabaseConfig() {
        return this.config;
    }

    public FileConfiguration getGuisConfig() {
        return this.guisConfig;
    }

    public GuiConfig getGuiConfig() {
        return this.guiConfig;
    }

    @NotNull
    public FileConfiguration getQuestsConfig() {
        return this.questsConfig;
    }

    public String getLanguage() {
        return this.language;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Set<String> getSupportedLanguages() {
        return Set.of("ar", "bn", "en", "es", "fr", "hi", "id", "pt", "ru", "zh");
    }

    public String getLanguageDisplayName(String code) {
        Map<String, String> languageNames = Map.of("ar", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 (Arabic)", "bn", "\u09ac\u09be\u0982\u09b2\u09be (Bengali)", "en", "English", "es", "Espa\u00f1ol (Spanish)", "fr", "Fran\u00e7ais (French)", "hi", "\u0939\u093f\u0928\u094d\u0926\u0940 (Hindi)", "id", "Bahasa Indonesia (Indonesian)", "pt", "Portugu\u00eas (Portuguese)", "ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439 (Russian)", "zh", "\u4e2d\u6587 (Chinese)");
        return languageNames.getOrDefault(code, "Unknown (" + code + ")");
    }

    public Set<String> getAllConfiguredJobNames() {
        HashSet<String> jobNames = new HashSet<String>();
        this.landLevels.values().forEach(level -> level.jobRequirements().forEach(req -> jobNames.add(req.jobName())));
        return jobNames;
    }
}

